/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.storage.services;

import io.github.nucleuspowered.storage.dataobjects.IDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.DataKey;
import io.github.nucleuspowered.storage.dataobjects.keyed.IKeyedDataObject;
import io.github.nucleuspowered.storage.queryobjects.IQueryObject;
import io.github.nucleuspowered.storage.util.KeyedObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface IStorageService<D extends IDataObject> {
    public D createNew();

    public CompletableFuture<Void> ensureSaved();

    public CompletableFuture<Void> clearCache();

    public static interface Keyed<K, Q extends IQueryObject<K, Q>, D extends IDataObject>
    extends IStorageService<D> {
        default public boolean supportsNonPrimaryKeyQueries() {
            return false;
        }

        public CompletableFuture<Optional<D>> get(@Nonnull K var1);

        public Optional<D> getOnThread(@Nonnull K var1);

        default public CompletableFuture<D> getOrNew(@Nonnull K key) {
            return this.get((Q)key).thenApply(d -> d.orElseGet(() -> {
                Object result = this.createNew();
                this.save(key, result);
                return result;
            }));
        }

        default public D getOrNewOnThread(@Nonnull K key) {
            return (D)this.getOnThread(key).orElseGet(() -> {
                Object result = this.createNew();
                this.save(key, result);
                return result;
            });
        }

        public CompletableFuture<Optional<KeyedObject<K, D>>> get(@Nonnull Q var1);

        public CompletableFuture<Map<K, D>> getAll(@Nonnull Q var1);

        public CompletableFuture<Boolean> exists(@Nonnull K var1);

        default public CompletableFuture<Boolean> exists(@Nonnull Q query) {
            return this.count(query).thenApply(x -> x > 0);
        }

        public CompletableFuture<Integer> count(@Nonnull Q var1);

        public CompletableFuture<Void> save(@Nonnull K var1, @Nonnull D var2);

        public CompletableFuture<Void> delete(@Nonnull K var1);

        public CompletableFuture<Void> clearCacheUnless(Set<K> var1);

        public static interface KeyedData<K, Q extends IQueryObject<K, Q>, D extends IKeyedDataObject<D>>
        extends Keyed<K, Q, D> {
            public <T2> CompletableFuture<Void> setAndSave(@Nonnull K var1, DataKey<T2, ? extends D> var2, T2 var3);

            public <T2> CompletableFuture<Void> removeAndSave(@Nonnull K var1, DataKey<T2, ? extends D> var2);
        }
    }

    public static interface SingleCached<D extends IDataObject>
    extends Single<D> {
        public CompletableFuture<Void> reload();

        public void saveCached();

        public Optional<D> getCached();
    }

    public static interface Single<D extends IDataObject>
    extends IStorageService<D> {
        public CompletableFuture<Optional<D>> get();

        public Optional<D> getOnThread();

        default public CompletableFuture<D> getOrNew() {
            return this.get().thenApply(d -> d.orElseGet(() -> {
                Object result = this.createNew();
                this.save(result);
                return result;
            }));
        }

        default public D getOrNewOnThread() {
            return (D)this.getOnThread().orElseGet(() -> {
                Object result = this.createNew();
                this.save(result);
                return result;
            });
        }

        public CompletableFuture<Void> save(@Nonnull D var1);
    }
}

