/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.entity;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.planets.nibiru.entity.ai.EntityAIFleeNibiruThunder;
import stevekung.mods.moreplanets.planets.nibiru.entity.ai.EntityAIShlimeEatGrass;
import stevekung.mods.moreplanets.utils.entity.ISpaceMob;
import stevekung.mods.moreplanets.utils.entity.ai.PathNavigateGroundMP;

public class EntityShlime
extends EntityAnimal
implements IShearable,
ISpaceMob,
IEntityBreathable {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityShlime.class, (DataSerializer)DataSerializers.field_187191_a);
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }
    }, 2, 1);
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private EntityAIShlimeEatGrass entityAIEatGrass;
    private int sheepTimer;
    private float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;

    public EntityShlime(World world) {
        super(world);
        this.func_70105_a(0.675f, 0.9f);
        this.field_70767_i = new ShlimeJumpHelper(this);
        this.field_70765_h = new ShlimeMoveHelper(this);
        this.inventoryCrafting.func_70299_a(0, new ItemStack(Items.field_151100_aR, 1, 0));
        this.inventoryCrafting.func_70299_a(1, new ItemStack(Items.field_151100_aR, 1, 0));
        this.setMovementSpeed(0.0);
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIShlimeEatGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(this, 2.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.6, false, (Set)Sets.newHashSet((Object[])new Item[]{MPItems.INFECTED_WHEAT, MPItems.TERRABERRY})));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFleeNibiruThunder((EntityCreature)this, 2.2));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
        if (onGround) {
            if (this.field_70143_R > 0.0f) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateGroundMP((EntityLiving)this, world);
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() == MPPotions.INFECTED_SPORE ? false : super.func_70687_e(potion);
    }

    public boolean canBreath() {
        return true;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    public boolean func_70601_bi() {
        Block block = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
        return (block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.GREEN_VEIN_GRASS_BLOCK) && this.field_70170_p.func_175699_k(this.func_180425_c()) > 8 && this.func_180484_a(this.func_180425_c()) >= 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    public void func_70071_h_() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        if (this.sheepTimer > 0 && this.sheepTimer <= 40) {
            Block blockDown = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
            IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c());
            if (blockDown == MPBlocks.INFECTED_GRASS_BLOCK) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)MPBlocks.INFECTED_GRASS_BLOCK.func_176223_P())});
            } else if (blockDown == MPBlocks.GREEN_VEIN_GRASS_BLOCK) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)MPBlocks.GREEN_VEIN_GRASS_BLOCK.func_176223_P())});
            } else if (state == MPBlocks.INFECTED_GRASS.func_176223_P()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)MPBlocks.INFECTED_GRASS.func_176223_P())});
            } else if (state == MPBlocks.GREEN_VEIN_GRASS.func_176223_P()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)MPBlocks.GREEN_VEIN_GRASS.func_176223_P())});
            }
        }
        this.alterSquishAmount();
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u + 0.5) {
                    return 0.7f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.4f : 0.7f;
        }
        return 0.7f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.2f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            this.func_184185_a(SoundEvents.field_187898_fy, 0.3f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f) * 0.8f);
        }
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            ShlimeJumpHelper helper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(helper = (ShlimeJumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!helper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MPSounds.SHLIME_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MPSounds.SHLIME_DEATH;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return MPLootTables.SHLIME;
        }
        switch (this.getFleeceColor()) {
            default: {
                return MPLootTables.SHLIME_WOOL_WHITE;
            }
            case ORANGE: {
                return MPLootTables.SHLIME_WOOL_ORANGE;
            }
            case MAGENTA: {
                return MPLootTables.SHLIME_WOOL_MAGENTA;
            }
            case LIGHT_BLUE: {
                return MPLootTables.SHLIME_WOOL_LIGHT_BLUE;
            }
            case YELLOW: {
                return MPLootTables.SHLIME_WOOL_YELLOW;
            }
            case LIME: {
                return MPLootTables.SHLIME_WOOL_LIME;
            }
            case PINK: {
                return MPLootTables.SHLIME_WOOL_PINK;
            }
            case GRAY: {
                return MPLootTables.SHLIME_WOOL_GRAY;
            }
            case SILVER: {
                return MPLootTables.SHLIME_WOOL_SILVER;
            }
            case CYAN: {
                return MPLootTables.SHLIME_WOOL_CYAN;
            }
            case PURPLE: {
                return MPLootTables.SHLIME_WOOL_PURPLE;
            }
            case BLUE: {
                return MPLootTables.SHLIME_WOOL_BLUE;
            }
            case BROWN: {
                return MPLootTables.SHLIME_WOOL_BROWN;
            }
            case GREEN: {
                return MPLootTables.SHLIME_WOOL_GREEN;
            }
            case RED: {
                return MPLootTables.SHLIME_WOOL_RED;
            }
            case BLACK: 
        }
        return MPLootTables.SHLIME_WOOL_BLACK;
    }

    public EntityShlime createChild(EntityAgeable ageable) {
        EntityShlime parent = (EntityShlime)ageable;
        EntityShlime child = new EntityShlime(this.field_70170_p);
        child.setFleeceColor(this.getDyeColorMixFromParents(this, parent));
        return child;
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setFleeceColor(this.getRandomSheepColor(this.field_70170_p.field_73012_v));
        return super.func_180482_a(difficulty, data);
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return !itemStack.func_190926_b() && (itemStack.func_77973_b() == MPItems.INFECTED_WHEAT || itemStack.func_77973_b() == MPItems.TERRABERRY);
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Sheared", this.getSheared());
        tagCompound.func_74774_a("Color", (byte)this.getFleeceColor().func_176765_a());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setSheared(tagCompund.func_74767_n("Sheared"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)tagCompund.func_74771_c("Color")));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_174808_Z();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotationAngleX(float partialTicks) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - partialTicks) / 16.0f;
            return -0.62831855f + 0.439823f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : -76.39437f;
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    private void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    private void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    private void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    private EnumDyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        return i < 5 ? EnumDyeColor.BLACK : (i < 10 ? EnumDyeColor.GRAY : (i < 15 ? EnumDyeColor.SILVER : (i < 18 ? EnumDyeColor.BROWN : (random.nextInt(500) == 0 ? EnumDyeColor.PINK : EnumDyeColor.WHITE))));
    }

    private EnumDyeColor getDyeColorMixFromParents(EntityAnimal father, EntityAnimal mother) {
        int i = ((EntityShlime)father).getFleeceColor().func_176767_b();
        int j = ((EntityShlime)mother).getFleeceColor().func_176767_b();
        this.inventoryCrafting.func_70301_a(0).func_77964_b(i);
        this.inventoryCrafting.func_70301_a(1).func_77964_b(j);
        ItemStack itemStack = CraftingManager.func_82787_a((InventoryCrafting)this.inventoryCrafting, (World)((EntityShlime)father).field_70170_p);
        int k = !itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151100_aR ? itemStack.func_77960_j() : (this.field_70170_p.field_73012_v.nextBoolean() ? i : j);
        return EnumDyeColor.func_176766_a((int)k);
    }

    private void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((ShlimeJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((ShlimeJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    static class AIPanic
    extends EntityAIPanic {
        private final EntityShlime entity;

        public AIPanic(EntityShlime entity, double speed) {
            super((EntityCreature)entity, speed);
            this.entity = entity;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.entity.setMovementSpeed(this.field_75265_b);
        }
    }

    static class ShlimeMoveHelper
    extends EntityMoveHelper {
        private final EntityShlime entity;
        private double nextJumpSpeed;

        public ShlimeMoveHelper(EntityShlime entity) {
            super((EntityLiving)entity);
            this.entity = entity;
        }

        public void func_75641_c() {
            if (this.entity.field_70122_E && !this.entity.field_70703_bu && !((ShlimeJumpHelper)this.entity.field_70767_i).getIsJumping()) {
                this.entity.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.entity.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speed) {
            if (this.entity.func_70090_H()) {
                speed = 1.5;
            }
            super.func_75642_a(x, y, z, speed);
            if (speed > 0.0) {
                this.nextJumpSpeed = speed;
            }
        }
    }

    static class ShlimeJumpHelper
    extends EntityJumpHelper {
        private final EntityShlime entity;
        private boolean canJump;

        public ShlimeJumpHelper(EntityShlime entity) {
            super((EntityLiving)entity);
            this.entity = entity;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.entity.startJumping();
                this.field_75662_b = false;
            }
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }
    }
}

