/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractBoundedComparableData<T extends Comparable<T>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<T, M, I> {
    private final Class<? extends I> immutableClass;
    protected final Comparator<T> comparator;
    protected final T lowerBound;
    protected final T upperBound;
    protected final T defaultValue;

    protected AbstractBoundedComparableData(Class<M> manipulatorClass, T value, Key<? extends BaseValue<T>> usedKey, Comparator<T> comparator, Class<? extends I> immutableClass, T lowerBound, T upperBound, T defaultValue) {
        super(manipulatorClass, value, usedKey);
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
        Preconditions.checkArgument((!Modifier.isAbstract(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.immutableClass = (Class)Preconditions.checkNotNull(immutableClass);
        this.lowerBound = (Comparable)Preconditions.checkNotNull(lowerBound);
        this.upperBound = (Comparable)Preconditions.checkNotNull(upperBound);
        this.defaultValue = (Comparable)Preconditions.checkNotNull(defaultValue);
    }

    @Override
    public M copy() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.getClass(), this.getValue(), this.lowerBound, this.upperBound));
    }

    @Override
    protected MutableBoundedValue<T> getValueGetter() {
        return SpongeValueFactory.boundedBuilder(this.usedKey).minimum(this.lowerBound).maximum(this.upperBound).defaultValue(this.defaultValue).comparator(this.comparator).actualValue(this.getValue()).build();
    }

    @Override
    public I asImmutable() {
        if (this.comparator.compare(this.upperBound, this.lowerBound) > 100) {
            return (I)((ImmutableDataManipulator)ReflectionUtil.createInstance(this.immutableClass, this.getValue(), this.lowerBound, this.upperBound, this.defaultValue));
        }
        return ImmutableDataCachingUtil.getManipulator(this.immutableClass, this.getValue(), this.lowerBound, this.upperBound, this.defaultValue);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), this.getValue());
    }
}

