/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableMappedData;
import org.spongepowered.api.data.manipulator.mutable.MappedData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.util.CollectionUtils;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractMappedData<K, V, M extends MappedData<K, V, M, I>, I extends ImmutableMappedData<K, V, I, M>>
extends AbstractSingleData<Map<K, V>, M, I>
implements MappedData<K, V, M, I> {
    private final Class<? extends I> immutableClass;

    public AbstractMappedData(Class<M> manipulatorClass, Map<K, V> value, Key<? extends BaseValue<Map<K, V>>> usedKey, Class<? extends I> immutableClass) {
        super(manipulatorClass, CollectionUtils.copyMap(value), usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(immutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.immutableClass = immutableClass;
    }

    @Override
    public M copy() {
        return (M)((MappedData)ReflectionUtil.createInstance(this.getClass(), this.getValue()));
    }

    @Override
    public I asImmutable() {
        return (I)((ImmutableMappedData)ReflectionUtil.createInstance(this.immutableClass, this.getValue()));
    }

    protected MapValue<K, V> getValueGetter() {
        return new SpongeMapValue(this.usedKey, this.getValue());
    }

    @Override
    protected Map<K, V> getValue() {
        return Maps.newHashMap((Map)((Map)super.getValue()));
    }

    @Override
    protected M setValue(Map<K, V> value) {
        return (M)((MappedData)super.setValue(Maps.newHashMap(value)));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.getValue()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractMappedData other = (AbstractMappedData)obj;
        return Objects.equal((Object)this.getValue(), (Object)other.getValue());
    }

    @Override
    public Optional<V> get(K key) {
        return Optional.of(((Map)super.getValue()).get(Preconditions.checkNotNull(key)));
    }

    @Override
    public Set<K> getMapKeys() {
        return ImmutableSet.copyOf(((Map)super.getValue()).keySet());
    }

    @Override
    public MapValue<K, V> getMapValue() {
        return this.getValueGetter();
    }

    @Override
    public Map<K, V> asMap() {
        return this.getValue();
    }

    @Override
    public M put(K key, V value) {
        ((Map)super.getValue()).put(Preconditions.checkNotNull(key, (Object)"Key cannot be null!"), Preconditions.checkNotNull(value, (Object)"Value cannot be null!"));
        return (M)this;
    }

    @Override
    public M putAll(Map<? extends K, ? extends V> map) {
        ((Map)super.getValue()).putAll((Map)Preconditions.checkNotNull(map, (Object)"Map cannot be null!"));
        return (M)this;
    }

    @Override
    public M remove(K key) {
        ((Map)super.getValue()).remove(Preconditions.checkNotNull(key, (Object)"Key cannot be null!"));
        return (M)this;
    }
}

