/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.EnumTrait;
import org.spongepowered.api.block.trait.EnumTraits;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.AbstractPrefixCheckCatalogRegistryModule;

@RegisterCatalog(value=EnumTraits.class)
public final class EnumTraitRegistryModule
extends AbstractPrefixCheckCatalogRegistryModule<EnumTrait<?>>
implements SpongeAdditionalCatalogRegistryModule<EnumTrait<?>>,
AlternateCatalogRegistryModule<EnumTrait<?>> {
    public static EnumTraitRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(EnumTrait<?> extraCatalog) {
        this.catalogTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    public void registerBlock(String id, BlockType block, EnumTrait<?> property) {
        Preconditions.checkNotNull((Object)id, (Object)"Id was null!");
        Preconditions.checkNotNull(property, (Object)"Property was null!");
        this.catalogTypeMap.put(id.toLowerCase(Locale.ENGLISH), property);
        String propertyId = block.getId().toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH);
        this.catalogTypeMap.put(propertyId, property);
    }

    EnumTraitRegistryModule() {
        super("minecraft");
    }

    @Override
    public Map<String, EnumTrait<?>> provideCatalogMap() {
        HashMap map = new HashMap();
        for (Map.Entry enumTraitEntry : this.catalogTypeMap.entrySet()) {
            map.put(((String)enumTraitEntry.getKey()).replace("minecraft:", ""), (EnumTrait<?>)enumTraitEntry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final EnumTraitRegistryModule INSTANCE = new EnumTraitRegistryModule();

        private Holder() {
        }
    }
}

