/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteType;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.BlockPaletteWrapper;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongeBlockPaletteType;

public class BlockPaletteTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<BlockPaletteType>,
AlternateCatalogRegistryModule<BlockPaletteType> {
    @RegisterCatalog(value=BlockPaletteTypes.class)
    private final Map<String, BlockPaletteType> paletteMappings = Maps.newHashMap();

    @Override
    public void registerAdditionalCatalog(BlockPaletteType extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog);
        String id = extraCatalog.getId();
        Preconditions.checkArgument((id.indexOf(32) == -1 ? 1 : 0) != 0, (Object)("Palette Type ID " + id + " may not contain a space"));
        this.paletteMappings.put(id.toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<BlockPaletteType> getById(String id) {
        if ("global".equalsIgnoreCase(id)) {
            id = "global_blocks";
        } else if ("local".equalsIgnoreCase(id)) {
            id = "local_blocks";
        }
        return Optional.ofNullable(this.paletteMappings.get(id));
    }

    @Override
    public Collection<BlockPaletteType> getAll() {
        return ImmutableList.copyOf(this.paletteMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.registerAdditionalCatalog(new SpongeBlockPaletteType("global_blocks", () -> (BlockPalette)GlobalPalette.getBlockPalette()));
        this.registerAdditionalCatalog(new SpongeBlockPaletteType("local_blocks", () -> new BlockPaletteWrapper(new BimapPalette<BlockState>(PaletteTypes.LOCAL_BLOCKS), BlockPaletteTypes.LOCAL)));
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }

    @Override
    public Map<String, BlockPaletteType> provideCatalogMap() {
        HashMap<String, BlockPaletteType> map = new HashMap<String, BlockPaletteType>();
        this.paletteMappings.forEach((key, value) -> map.put(key.split("_")[0], (BlockPaletteType)value));
        return map;
    }
}

