/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.scheduler.ScheduledTask;
import org.spongepowered.common.scheduler.SchedulerBase;

class TaskExecutorService
extends AbstractExecutorService
implements SpongeExecutorService {
    private final Supplier<Task.Builder> taskBuilderProvider;
    private final SchedulerBase scheduler;
    private final PluginContainer plugin;

    protected TaskExecutorService(Supplier<Task.Builder> taskBuilderProvider, SchedulerBase scheduler, PluginContainer plugin) {
        this.taskBuilderProvider = taskBuilderProvider;
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return ImmutableList.of();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void execute(Runnable command) {
        this.createTask(command).submit(this.plugin);
    }

    @Override
    public SpongeExecutorService.SpongeFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        FutureTask<Object> runnable = new FutureTask<Object>(command, null);
        Task task = this.createTask(runnable).delay(delay, unit).submit(this.plugin);
        return new SpongeTaskFuture<Object>(runnable, (ScheduledTask)task, this.scheduler);
    }

    @Override
    public <V> SpongeExecutorService.SpongeFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        FutureTask<V> runnable = new FutureTask<V>(callable);
        Task task = this.createTask(runnable).delay(delay, unit).submit(this.plugin);
        return new SpongeTaskFuture<V>(runnable, (ScheduledTask)task, this.scheduler);
    }

    @Override
    public SpongeExecutorService.SpongeFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        RepeatableFutureTask runnable = new RepeatableFutureTask(command);
        Task task = this.createTask(runnable).delay(initialDelay, unit).interval(period, unit).submit(this.plugin);
        runnable.setTask(task);
        return new SpongeTaskFuture(runnable, (ScheduledTask)task, this.scheduler);
    }

    @Override
    public SpongeExecutorService.SpongeFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    private Task.Builder createTask(Runnable command) {
        return this.taskBuilderProvider.get().execute(command);
    }

    private static class RepeatableFutureTask<V>
    extends FutureTask<V> {
        @Nullable
        private Task owningTask = null;

        protected RepeatableFutureTask(Runnable runnable) {
            super(runnable, null);
        }

        protected void setTask(Task task) {
            this.owningTask = task;
            if (this.isDone() && !this.isCancelled()) {
                this.owningTask.cancel();
            }
        }

        @Override
        protected void done() {
            if (!this.isCancelled() && this.owningTask != null) {
                this.owningTask.cancel();
            }
        }

        @Override
        public void run() {
            super.runAndReset();
        }
    }

    private static class SpongeTaskFuture<V>
    implements SpongeExecutorService.SpongeFuture<V> {
        private final FutureTask<V> runnable;
        private final ScheduledTask task;
        private final SchedulerBase scheduler;

        SpongeTaskFuture(FutureTask<V> runnable, ScheduledTask task, SchedulerBase scheduler) {
            this.runnable = runnable;
            this.task = task;
            this.scheduler = scheduler;
        }

        @Override
        public Task getTask() {
            return this.task;
        }

        @Override
        public boolean isPeriodic() {
            return this.task.getInterval() > 0L;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.task.nextExecutionTimestamp() - this.scheduler.getTimestamp(this.task), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof SpongeTaskFuture) {
                ScheduledTask otherTask = ((SpongeTaskFuture)other).task;
                return ComparisonChain.start().compare(this.task.nextExecutionTimestamp(), otherTask.nextExecutionTimestamp()).compare((Comparable)this.task.getUniqueId(), (Comparable)otherTask.getUniqueId()).result();
            }
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), other.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.task.cancel();
            return this.runnable.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.runnable.isCancelled() || this.task.getState() == ScheduledTask.ScheduledTaskState.CANCELED && !this.runnable.isDone();
        }

        @Override
        public boolean isDone() {
            return this.runnable.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.runnable.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.runnable.get(timeout, unit);
        }
    }
}

