/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.action.CollideEvent;
import org.spongepowered.api.event.action.LightningEvent;
import org.spongepowered.api.event.advancement.AdvancementEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.ChangeEntityExperienceEvent;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.HarvestEntityEvent;
import org.spongepowered.api.event.entity.HealEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RideEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.event.statistic.ChangeStatisticEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.event.world.chunk.LoadChunkEvent;
import org.spongepowered.api.event.world.chunk.UnloadChunkEvent;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.EventType;
import org.spongepowered.common.event.RegisteredListener;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.mod.SpongeMod;
import org.spongepowered.mod.bridge.event.EventBusBridge_Forge;
import org.spongepowered.mod.bridge.fml.LoadControllerBridge_Forge;
import org.spongepowered.mod.event.ForgeToSpongeEventData;
import org.spongepowered.mod.event.ForgeToSpongeEventFactory;
import org.spongepowered.mod.event.SpongeToForgeEventData;
import org.spongepowered.mod.event.SpongeToForgeEventFactory;

@Singleton
public class SpongeModEventManager
extends SpongeEventManager {
    private final ImmutableBiMap<EventPriority, Order> priorityMappings = new ImmutableBiMap.Builder().put((Object)EventPriority.HIGHEST, (Object)Order.FIRST).put((Object)EventPriority.HIGH, (Object)Order.EARLY).put((Object)EventPriority.NORMAL, (Object)Order.DEFAULT).put((Object)EventPriority.LOW, (Object)Order.LATE).put((Object)EventPriority.LOWEST, (Object)Order.LAST).build();
    private Class<? extends Event>[] useItemStack = new Class[]{UseItemStackEvent.Start.class, UseItemStackEvent.Tick.class, UseItemStackEvent.Stop.class, UseItemStackEvent.Finish.class, UseItemStackEvent.Replace.class, UseItemStackEvent.Reset.class};
    private Class<? extends Event>[] interactEntity = new Class[]{InteractEntityEvent.Primary.MainHand.class, InteractEntityEvent.Primary.OffHand.class, InteractEntityEvent.Secondary.MainHand.class, InteractEntityEvent.Secondary.OffHand.class};
    private Class<? extends Event>[] interactBlock = new Class[]{InteractBlockEvent.Primary.MainHand.class, InteractBlockEvent.Primary.OffHand.class, InteractBlockEvent.Secondary.MainHand.class, InteractBlockEvent.Secondary.OffHand.class};
    private Class<? extends Event>[] spawnEntityEvent = new Class[]{SpawnEntityEvent.ChunkLoad.class, SpawnEntityEvent.Spawner.class, SpawnEntityEvent.class};
    public final ImmutableMultimap<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>, Class<? extends Event>> forgeToSpongeEventMapping = new ImmutableMultimap.Builder().put(ItemExpireEvent.class, DestructEntityEvent.Death.class).put(ItemTossEvent.class, DropItemEvent.Dispense.class).put(EnderTeleportEvent.class, MoveEntityEvent.Teleport.Portal.class).put(LivingAttackEvent.class, AttackEntityEvent.class).put(LivingDeathEvent.class, DestructEntityEvent.Death.class).putAll(LivingDropsEvent.class, (Object[])new Class[]{DropItemEvent.Destruct.class, DropItemEvent.Custom.class}).putAll(LivingEntityUseItemEvent.class, (Object[])this.useItemStack).put(LivingEvent.LivingJumpEvent.class, MoveEntityEvent.class).put(LivingExperienceDropEvent.class, HarvestEntityEvent.TargetPlayer.class).put(LivingHealEvent.class, HealEntityEvent.class).put(LivingHurtEvent.class, AttackEntityEvent.class).putAll(LivingSpawnEvent.class, (Object[])new Class[]{SpawnEntityEvent.Spawner.class}).putAll(ZombieEvent.class, (Object[])new Class[]{SpawnEntityEvent.ChunkLoad.class, SpawnEntityEvent.Spawner.class}).put(MinecartCollisionEvent.class, CollideEntityEvent.Impact.class).putAll(MinecartInteractEvent.class, (Object[])this.interactEntity).put(ArrowLooseEvent.class, SpawnEntityEvent.Spawner.class).putAll(ArrowNockEvent.class, (Object[])this.useItemStack).put(net.minecraftforge.event.entity.player.AttackEntityEvent.class, AttackEntityEvent.class).putAll(BonemealEvent.class, (Object[])this.interactBlock).putAll(BonemealEvent.class, (Object[])this.useItemStack).putAll(EntityItemPickupEvent.class, (Object[])new Class[]{ChangeInventoryEvent.Pickup.Pre.class, DestructEntityEvent.class}).putAll(FillBucketEvent.class, (Object[])this.interactBlock).putAll(FillBucketEvent.class, (Object[])this.useItemStack).putAll(PlayerDestroyItemEvent.class, (Object[])new Class[]{DestructEntityEvent.class, DropItemEvent.Destruct.class}).putAll(PlayerDropsEvent.class, (Object[])new Class[]{DropItemEvent.Dispense.class, DropItemEvent.Destruct.class, DestructEntityEvent.Death.class}).putAll(PlayerEvent.HarvestCheck.class, (Object[])new Class[]{ChangeBlockEvent.Modify.class, ChangeBlockEvent.Post.class}).put(PlayerFlyableFallEvent.class, MoveEntityEvent.class).putAll(PlayerInteractEvent.EntityInteractSpecific.class, (Object[])new Class[]{InteractEntityEvent.Secondary.MainHand.class, InteractEntityEvent.Secondary.OffHand.class}).putAll(PlayerInteractEvent.RightClickBlock.class, (Object[])new Class[]{InteractBlockEvent.Secondary.MainHand.class, InteractBlockEvent.Secondary.OffHand.class}).putAll(PlayerInteractEvent.RightClickItem.class, (Object[])new Class[]{InteractBlockEvent.Secondary.MainHand.class, InteractBlockEvent.Secondary.OffHand.class}).putAll(PlayerInteractEvent.LeftClickBlock.class, (Object[])new Class[]{InteractBlockEvent.Primary.MainHand.class, InteractBlockEvent.Primary.OffHand.class}).putAll(PlayerInteractEvent.LeftClickEmpty.class, (Object[])new Class[]{InteractBlockEvent.Primary.MainHand.class, InteractBlockEvent.Primary.OffHand.class}).putAll(PlayerPickupXpEvent.class, (Object[])new Class[]{ChangeEntityExperienceEvent.class, DestructEntityEvent.class}).putAll(UseHoeEvent.class, (Object[])this.interactBlock).putAll(UseHoeEvent.class, (Object[])this.useItemStack).putAll(EntityEvent.EntityConstructing.class, (Object[])new Class[]{ConstructEntityEvent.Pre.class, ConstructEntityEvent.Post.class}).putAll(EntityEvent.EntityConstructing.class, (Object[])this.spawnEntityEvent).put(EntityEvent.EnteringChunk.class, MoveEntityEvent.class).putAll(EntityJoinWorldEvent.class, (Object[])this.spawnEntityEvent).putAll(EntityMountEvent.class, (Object[])new Class[]{RideEntityEvent.Dismount.class, RideEntityEvent.Mount.class}).putAll(EntityStruckByLightningEvent.class, (Object[])new Class[]{LightningEvent.Pre.class, LightningEvent.Strike.class, LightningEvent.Post.class}).put(EntityTravelToDimensionEvent.class, MoveEntityEvent.Teleport.Portal.class).putAll(BlockEvent.PlaceEvent.class, (Object[])new Class[]{ChangeBlockEvent.Place.class, ChangeBlockEvent.Modify.class, ChangeBlockEvent.Post.class}).putAll(BlockEvent.MultiPlaceEvent.class, (Object[])new Class[]{ChangeBlockEvent.Place.class}).put(BlockEvent.NeighborNotifyEvent.class, NotifyNeighborBlockEvent.class).put(ChunkEvent.Load.class, LoadChunkEvent.class).put(ChunkEvent.Unload.class, UnloadChunkEvent.class).put(ExplosionEvent.Start.class, ExplosionEvent.Pre.class).put(ExplosionEvent.Detonate.class, ExplosionEvent.Detonate.class).put(WorldEvent.Load.class, LoadWorldEvent.class).put(WorldEvent.Unload.class, UnloadWorldEvent.class).put(CommandEvent.class, SendCommandEvent.class).put(ServerChatEvent.class, MessageChannelEvent.Chat.class).putAll(PlayerEvent.ItemPickupEvent.class, (Object[])new Class[]{DestructEntityEvent.class, ChangeInventoryEvent.Pickup.class}).putAll(PlayerEvent.PlayerLoggedInEvent.class, (Object[])new Class[]{ClientConnectionEvent.Auth.class, ClientConnectionEvent.Login.class, ClientConnectionEvent.Join.class}).put(PlayerEvent.PlayerLoggedOutEvent.class, ClientConnectionEvent.Disconnect.class).put(PlayerEvent.PlayerChangedDimensionEvent.class, MoveEntityEvent.Teleport.Portal.class).put(AdvancementEvent.class, AdvancementEvent.Grant.class).build();

    @Inject
    public SpongeModEventManager(Logger logger, PluginManager pluginManager) {
        super(logger, pluginManager);
    }

    private boolean areStartupTimingsEnabled() {
        return SpongeImpl.getGame().getState().ordinal() < GameState.SERVER_ABOUT_TO_START.ordinal();
    }

    public static boolean shouldUseCauseStackManager(boolean allowClientThread) {
        if (!SpongeImpl.isInitialized()) {
            return false;
        }
        boolean client = Sponge.getGame().getPlatform().getExecutionType().isClient();
        boolean hasServer = Sponge.isServerAvailable();
        return allowClientThread && client && !hasServer || hasServer && Sponge.getServer().isMainThread();
    }

    public boolean post(ForgeToSpongeEventData eventData) {
        Throwable throwable;
        CauseStackManager.StackFrame frame;
        boolean hasForgeListeners;
        boolean bl = hasForgeListeners = eventData.getForgeListeners().length > 0;
        if (hasForgeListeners) {
            eventData.setBeforeModifications(true);
            frame = Sponge.getCauseStackManager().pushCauseFrame();
            throwable = null;
            try {
                ForgeToSpongeEventFactory.createAndPostSpongeEvent(frame, eventData);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (frame != null) {
                    if (throwable != null) {
                        try {
                            frame.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        frame.close();
                    }
                }
            }
            if (eventData.getSpongeEvent() == null) {
                ((EventBusBridge_Forge)MinecraftForge.EVENT_BUS).forgeBridge$post(eventData.getForgeEvent(), true);
                return eventData.getForgeEvent().isCancelable() && eventData.getForgeEvent().isCanceled();
            }
            if (eventData.getForgeEvent().isCancelable() && eventData.getForgeEvent().isCanceled()) {
                return true;
            }
            SpongeToForgeEventData spongeEventData = new SpongeToForgeEventData(eventData);
            SpongeToForgeEventFactory.createAndPostForgeEvent(spongeEventData);
        }
        eventData.setBeforeModifications(false);
        eventData.setForced(!hasForgeListeners);
        frame = Sponge.getCauseStackManager().pushCauseFrame();
        throwable = null;
        try {
            ForgeToSpongeEventFactory.createAndPostSpongeEvent(frame, eventData);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (frame != null) {
                if (throwable != null) {
                    try {
                        frame.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    frame.close();
                }
            }
        }
        ForgeToSpongeEventFactory.onPostEnd(eventData);
        return eventData.getForgeEvent().isCancelable() && eventData.getForgeEvent().isCanceled();
    }

    private SpongeToForgeEventData post(SpongeToForgeEventData eventData) {
        boolean hasSpongeListeners;
        Event spongeEvent = eventData.getSpongeEvent();
        boolean bl = hasSpongeListeners = !eventData.getSpongeListenerCache().getListeners().isEmpty();
        if (hasSpongeListeners) {
            for (Order order : Order.values()) {
                this.post(spongeEvent, eventData.getSpongeListenerCache().getListenersByOrder(order), true, false, eventData.useCauseStackManager());
            }
        }
        SpongeToForgeEventFactory.createAndPostForgeEvent(eventData);
        if (hasSpongeListeners) {
            SpongeToForgeEventFactory.handlePrefireLogic(spongeEvent);
            for (Order order : Order.values()) {
                this.post(spongeEvent, eventData.getSpongeListenerCache().getListenersByOrder(order), false, false, eventData.useCauseStackManager());
            }
        }
        return eventData;
    }

    void postEvent(ForgeToSpongeEventData eventData) {
        for (Order order : Order.values()) {
            this.post(eventData.getSpongeEvent(), eventData.getSpongeListenerCache().getListenersByOrder(order), eventData.isBeforeModifications(), eventData.isForced(), eventData.useCauseStackManager());
        }
        eventData.propagateCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event, List<RegisteredListener<?>> listeners, boolean beforeModifications, boolean forced, boolean useCauseStackManager) {
        ModContainer oldContainer = ((LoadControllerBridge_Forge)SpongeMod.instance.getController()).forgeBridge$getActiveModContainer();
        for (RegisteredListener<?> listener : listeners) {
            ((LoadControllerBridge_Forge)SpongeMod.instance.getController()).forgeBridge$setActiveModContainer((ModContainer)listener.getPlugin());
            try {
                if (!forced && (listener.isBeforeModifications() || beforeModifications) && (!listener.isBeforeModifications() || !beforeModifications)) continue;
                listener.getTimingsHandler().startTimingIfSync();
                if (event instanceof AbstractEvent) {
                    ((AbstractEvent)event).currentOrder = listener.getOrder();
                }
                if (useCauseStackManager) {
                    CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                    Throwable throwable = null;
                    try {
                        frame.pushCause(listener.getPlugin());
                        listener.handle(event);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (frame == null) continue;
                        if (throwable != null) {
                            try {
                                frame.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        frame.close();
                        continue;
                    }
                }
                listener.handle(event);
            }
            catch (Throwable e) {
                new PrettyPrinter(60).add("%s %s", "Could not pass ", event.getClass().getSimpleName()).centre().hr().add("Could not pass the event %s to an Event Listener!", event.getClass().getSimpleName()).add().add("Since the event can be modified during the event's listener,").add("there could be adverse side effects of the exception occurring").add("such that duplications or other game breaking issues could exist.").add().add("Due to the nature of the exception, this is not likely an exception").add("that is covered by SpongeForge or Forge itself, and therefore should").add("be reported to the mod/plugin author first prior to reporting to").add("Sponge or Forge.").add().add("%s: %s", "Owning Mod/Plugin", listener.getPlugin().getId()).add("Exception:").add(e).log(SpongeImpl.getLogger(), Level.WARN);
            }
            finally {
                listener.getTimingsHandler().stopTimingIfSync();
            }
        }
        if (event instanceof AbstractEvent) {
            ((AbstractEvent)event).currentOrder = null;
        }
        ((LoadControllerBridge_Forge)SpongeMod.instance.getController()).forgeBridge$setActiveModContainer(oldContainer);
        return event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled();
    }

    @Override
    public boolean post(@Nonnull Event spongeEvent, boolean allowClientThread) {
        this.extendedPost(spongeEvent, false, allowClientThread);
        return spongeEvent instanceof Cancellable && ((Cancellable)((Object)spongeEvent)).isCancelled();
    }

    public SpongeToForgeEventData extendedPost(Event spongeEvent, boolean requiresEventData, boolean allowClientThread) {
        if (!allowClientThread & Sponge.getGame().getPlatform().getExecutionType().isClient()) {
            return null;
        }
        boolean useCauseStackManager = SpongeModEventManager.shouldUseCauseStackManager(allowClientThread);
        RegisteredListener.Cache listenerCache = this.getHandlerCache(spongeEvent);
        Class<? extends net.minecraftforge.fml.common.eventhandler.Event> clazz = null;
        if (!this.isIgnoredEvent(spongeEvent) && spongeEvent.getClass().getInterfaces().length > 0 && (clazz = SpongeToForgeEventFactory.getForgeEventClass(spongeEvent)) != null) {
            Set<Class<? extends net.minecraftforge.fml.common.eventhandler.Event>> forgeListenerClassList = ((EventBusBridge_Forge)MinecraftForge.EVENT_BUS).forgeBridge$getEventListenerClassList();
            boolean hasListener = forgeListenerClassList.contains(clazz);
            if (!hasListener) {
                hasListener = forgeListenerClassList.contains(clazz.getSuperclass());
            }
            if (hasListener) {
                return this.post(new SpongeToForgeEventData(spongeEvent, clazz, listenerCache, useCauseStackManager));
            }
        }
        for (Order order : Order.values()) {
            this.post(spongeEvent, listenerCache.getListenersByOrder(order), false, true, useCauseStackManager);
        }
        if (requiresEventData) {
            return new SpongeToForgeEventData(spongeEvent, clazz, listenerCache, useCauseStackManager);
        }
        return null;
    }

    public boolean isIgnoredEvent(Event event) {
        if (event instanceof CollideEvent) {
            return true;
        }
        if (event instanceof ChangeStatisticEvent) {
            return true;
        }
        if (event instanceof ChangeDataHolderEvent) {
            return true;
        }
        return event instanceof MoveEntityEvent && !(event instanceof MoveEntityEvent.Teleport);
    }

    public RegisteredListener.Cache getHandlerCache(Class<? extends Event> eventClass) {
        EventType<? extends Event> eventType = new EventType<Event>(eventClass);
        return (RegisteredListener.Cache)this.handlersCache.get(eventType);
    }
}

