/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.misc.DataConstraints;

public final class ApiUtils {
    private ApiUtils() {
    }

    public static String checkUsername(String s, LuckPermsPlugin plugin) {
        if (s == null) {
            return null;
        }
        Predicate<String> test = plugin.getConfiguration().get(ConfigKeys.ALLOW_INVALID_USERNAMES) != false ? DataConstraints.PLAYER_USERNAME_TEST_LENIENT : DataConstraints.PLAYER_USERNAME_TEST;
        Preconditions.checkArgument((boolean)test.test(s), (Object)("Invalid username entry: " + s));
        return s;
    }

    public static String checkName(String s) {
        if (s == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)DataConstraints.GROUP_NAME_TEST.test(s), (Object)("Invalid name entry: " + s));
        return s.toLowerCase();
    }
}

