/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.contextset;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractContextSet
implements ContextSet {
    protected abstract SetMultimap<String, String> backing();

    protected abstract void copyTo(SetMultimap<String, String> var1);

    @Override
    public boolean containsKey(@NonNull String key) {
        return this.backing().containsKey((Object)AbstractContextSet.sanitizeKey(key));
    }

    @Override
    public @NonNull Set<String> getValues(@NonNull String key) {
        Collection values = (Collection)this.backing().asMap().get(AbstractContextSet.sanitizeKey(key));
        return values != null ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.of();
    }

    @Override
    public boolean contains(@NonNull String key, @NonNull String value) {
        return this.backing().containsEntry((Object)AbstractContextSet.sanitizeKey(key), (Object)AbstractContextSet.sanitizeValue(value));
    }

    @Override
    public boolean isSatisfiedBy(@NonNull ContextSet other, @NonNull ContextSatisfyMode mode) {
        if (this == other) {
            return true;
        }
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(mode, "mode");
        if (this.isEmpty()) {
            return true;
        }
        if (other.isEmpty()) {
            return false;
        }
        if (mode == ContextSatisfyMode.ALL_VALUES_PER_KEY && this.size() > other.size()) {
            return false;
        }
        return this.otherContainsAll(other, mode);
    }

    protected abstract boolean otherContainsAll(ContextSet var1, ContextSatisfyMode var2);

    public abstract Context[] toArray();

    @Override
    public @NonNull Iterator<Context> iterator() {
        return Iterators.forArray((Object[])this.toArray());
    }

    @Override
    public Spliterator<Context> spliterator() {
        return Arrays.spliterator(this.toArray());
    }

    @Override
    public boolean isEmpty() {
        return this.backing().isEmpty();
    }

    @Override
    public int size() {
        return this.backing().size();
    }

    public int hashCode() {
        return this.backing().hashCode();
    }

    static String sanitizeKey(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!Context.isValidKey(key)) {
            throw new IllegalArgumentException("key is (effectively) empty");
        }
        return key.toLowerCase();
    }

    static String sanitizeValue(String value) {
        Objects.requireNonNull(value, "value is null");
        if (!Context.isValidValue(value)) {
            throw new IllegalArgumentException("value is (effectively) empty");
        }
        return value.toLowerCase();
    }

    public static boolean isGlobalServerWorldEntry(String key, String value) {
        return (key.equals("server") || key.equals("world")) && value.equals("global");
    }
}

