/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class EnumNamer<E extends Enum<E>> {
    public static final Function<Enum<?>, String> LOWER_CASE_NAME = value -> value.name().toLowerCase();
    private final String[] names;
    private final Function<? super E, String> namingFunction;

    public EnumNamer(Class<E> enumClass, Map<? super E, String> definedNames, Function<? super E, String> namingFunction) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        this.names = new String[values.length];
        for (Enum value : values) {
            String name = definedNames.get(value);
            if (name == null) {
                name = namingFunction.apply(value);
            }
            this.names[value.ordinal()] = name;
        }
        this.namingFunction = namingFunction;
    }

    public EnumNamer(Class<E> enumClass, Function<? super E, String> namingFunction) {
        this(enumClass, Collections.emptyMap(), namingFunction);
    }

    public String name(E value) {
        int ordinal = ((Enum)value).ordinal();
        if (ordinal >= this.names.length) {
            return this.namingFunction.apply(value);
        }
        return this.names[ordinal];
    }
}

