/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;

public class OptionInfo
extends ChildCommand<LPSubjectData> {
    public OptionInfo() {
        super(CommandSpec.SPONGE_OPTION_INFO, "info", CommandPermission.SPONGE_OPTION_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, ArgumentList args, String label) {
        ImmutableContextSet contextSet = args.getContextOrEmpty(0);
        if (contextSet.isEmpty()) {
            SpongeCommandUtils.sendPrefixed(sender, "&aShowing options matching contexts &bANY&a.");
            ImmutableMap<ImmutableContextSet, ImmutableMap<String, String>> options = subjectData.getAllOptions();
            if (options.isEmpty()) {
                SpongeCommandUtils.sendPrefixed(sender, "That subject does not have any options defined.");
                return CommandResult.SUCCESS;
            }
            for (Map.Entry e : options.entrySet()) {
                SpongeCommandUtils.sendPrefixed(sender, "&3>> &bContext: " + SpongeCommandUtils.contextToString((ContextSet)e.getKey()) + "\n" + SpongeCommandUtils.optionsToString((Map)e.getValue()));
            }
        } else {
            ImmutableMap<String, String> options = subjectData.getOptions(contextSet);
            if (options.isEmpty()) {
                SpongeCommandUtils.sendPrefixed(sender, "That subject does not have any options defined in those contexts.");
                return CommandResult.SUCCESS;
            }
            SpongeCommandUtils.sendPrefixed(sender, "&aShowing options matching contexts &b" + SpongeCommandUtils.contextToString(contextSet) + "&a.\n" + SpongeCommandUtils.optionsToString(options));
        }
        return CommandResult.SUCCESS;
    }
}

