/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.management;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class PermsCommand
extends AbstractCommand {
    public PermsCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction faction = optionalPlayerFaction.get();
        if (!faction.getLeader().equals(player.getUniqueId()) && !super.getPlugin().getPlayerManager().hasAdminMode((User)player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_THE_FACTIONS_LEADER_TO_DO_THIS}));
        }
        this.showPerms(player, faction);
        return CommandResult.success();
    }

    private void showPerms(Player player, Faction faction) {
        Text.Builder textBuilder = Text.builder();
        for (Map.Entry<FactionMemberType, Map<FactionPermType, Boolean>> memberEntry : faction.getPerms().entrySet()) {
            Map<FactionPermType, Boolean> memberPerms = memberEntry.getValue();
            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, memberEntry.getKey().toString() + ": "})});
            for (Map.Entry<FactionPermType, Boolean> permEntry : memberPerms.entrySet()) {
                Text.Builder permTextBuilder = Text.builder();
                if (permEntry.getValue().booleanValue()) {
                    permTextBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, permEntry.getKey().toString()})});
                } else {
                    permTextBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.RED, permEntry.getKey().toString()})});
                }
                permTextBuilder.onClick((ClickAction)TextActions.executeCallback(this.togglePerm(faction, memberEntry.getKey(), permEntry.getKey(), permEntry.getValue() == false)));
                permTextBuilder.onHover((HoverAction)TextActions.showText((Text)Text.of((String)(Messages.SET_TO + " " + String.valueOf(permEntry.getValue() == false).toUpperCase()))));
                textBuilder.append(new Text[]{permTextBuilder.build()});
                textBuilder.append(new Text[]{Text.of((String)" | ")});
            }
            textBuilder.append(new Text[]{Text.of((String)"\n")});
        }
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.CLICK_ON_THE_PERMISSION_YOU_WANT_TO_CHANGE}));
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "RED", TextColors.RESET, " = " + Messages.HAS_NOT_PERMISSIONS_FOR}));
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "GREEN", TextColors.RESET, " = " + Messages.HAS_PERMISSIONS_FOR}));
        player.sendMessage((Text)Text.of((String)"=============================="));
        player.sendMessage(textBuilder.build());
    }

    private Consumer<CommandSource> togglePerm(Faction faction, FactionMemberType factionMemberType, FactionPermType factionPermType, Boolean flagValue) {
        return commandSource -> {
            this.getPlugin().getFactionLogic().togglePerm(faction, factionMemberType, factionPermType, flagValue);
            this.showPerms((Player)commandSource, faction);
        };
    }
}

