/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.rank;

import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class DemoteCommand
extends AbstractCommand {
    public DemoteCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        FactionPlayer demotedPlayer = (FactionPlayer)context.requireOne("player");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player sourcePlayer = (Player)source;
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(sourcePlayer.getUniqueId());
        Optional<Faction> optionalDemotedPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(demotedPlayer.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (!optionalDemotedPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLAYER_IS_NOT_IN_YOUR_FACTION}));
        }
        if (!optionalDemotedPlayerFaction.get().getName().equals(playerFaction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLAYER_IS_NOT_IN_YOUR_FACTION}));
        }
        if (super.getPlugin().getPlayerManager().hasAdminMode((User)sourcePlayer)) {
            if (playerFaction.getLeader().equals(demotedPlayer.getUniqueId()) || playerFaction.getRecruits().contains(demotedPlayer.getUniqueId())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_DEMOTE_THIS_PLAYER_MORE}));
            }
            return this.demotePlayer(sourcePlayer, demotedPlayer, playerFaction);
        }
        if (playerFaction.getLeader().equals(sourcePlayer.getUniqueId())) {
            if (playerFaction.getLeader().equals(demotedPlayer.getUniqueId()) || playerFaction.getRecruits().contains(demotedPlayer.getUniqueId())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_DEMOTE_THIS_PLAYER_MORE}));
            }
            return this.demotePlayer(sourcePlayer, demotedPlayer, playerFaction);
        }
        if (playerFaction.getOfficers().contains(sourcePlayer.getUniqueId())) {
            if (playerFaction.getLeader().equals(demotedPlayer.getUniqueId()) || playerFaction.getOfficers().contains(demotedPlayer.getUniqueId()) || playerFaction.getRecruits().contains(demotedPlayer.getUniqueId())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_CANT_DEMOTE_THIS_PLAYER_MORE}));
            }
            return this.demotePlayer(sourcePlayer, demotedPlayer, playerFaction);
        }
        throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS}));
    }

    private CommandResult demotePlayer(Player demotedBy, FactionPlayer demotedPlayer, Faction faction) {
        boolean isCancelled = EventRunner.runFactionDemoteEventPre(demotedBy, demotedPlayer, faction);
        if (isCancelled) {
            return CommandResult.success();
        }
        FactionMemberType demotedTo = this.getPlugin().getFactionLogic().demotePlayer(faction, demotedPlayer.getUniqueId());
        demotedBy.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, MessageLoader.parseMessage(Messages.YOU_DEMOTED_PLAYER_TO_MEMBER_TYPE, TextColors.GREEN, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.PLAYER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedPlayer.getName()}), (Object)Placeholders.MEMBER_TYPE, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, demotedTo.name()})))}));
        EventRunner.runFactionDemoteEventPost(demotedBy, demotedPlayer, demotedTo, faction);
        return CommandResult.success();
    }
}

