/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.messaging.chat;

import com.google.common.base.Preconditions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.messaging.chat.FactionMessageChannel;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import java.util.List;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.AbstractMutableMessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

public class FactionMessageChannelImpl
extends AbstractMutableMessageChannel
implements FactionMessageChannel {
    private final Faction faction;

    public static FactionMessageChannelImpl forFaction(Faction faction) {
        Preconditions.checkNotNull((Object)faction);
        return new FactionMessageChannelImpl(faction);
    }

    public FactionMessageChannelImpl(Faction faction) {
        this.faction = faction;
        this.getReceivers();
    }

    @Override
    public Faction getFaction() {
        return this.faction;
    }

    private void getReceivers() {
        List<Player> players = EagleFactionsPlugin.getPlugin().getFactionLogic().getOnlinePlayers(this.faction);
        for (Player player : players) {
            super.addMember((MessageReceiver)player);
        }
    }
}

