/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class FileUtils {
    public static void createFileIfNotExists(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    public static void createDirectoryIfNotExists(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public static boolean deleteDirectoryRecursive(File directory) {
        File[] children = directory.listFiles();
        if (children != null) {
            for (File file : children) {
                FileUtils.deleteDirectoryRecursive(file);
            }
        }
        return directory.delete();
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        return fileName.substring(0, index);
    }

    private FileUtils() {
    }
}

