/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockOxygenStorageModule;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileEntityAdvOxygenStorageModule
extends TileEntityOxygen
implements ISidedInventory {
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledOxygenLevel;
    private int lastScaledOxygenLevel;
    public static final int OUTPUT_PER_TICK = 600;
    public static final int OXYGEN_CAPACITY = 240000;

    public TileEntityAdvOxygenStorageModule() {
        this(1);
    }

    public TileEntityAdvOxygenStorageModule(int tier) {
        super("tile.oxygen_module_storage.name", 240000 * tier, 40);
        this.storage.setCapacity(0.0f);
        this.storage.setMaxExtract(0.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(0)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            int oxygenDraw = (int)Math.floor(Math.min((float)this.oxygenPerTick * 2.5f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
            this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
            if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                this.setOxygenStored(this.getOxygenStored());
            }
        }
        super.func_73660_a();
        this.scaledOxygenLevel = this.getScaledOxygenLevel(16);
        if (this.scaledOxygenLevel != this.lastScaledOxygenLevel) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
        this.produceOxygen(this.getFront().func_176746_e().func_176734_d());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.getInventory());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.getInventory());
        return nbt;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean shouldPullEnergy() {
        return false;
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    public EnumFacing getElectricInputDirection() {
        return null;
    }

    public ItemStack getBatteryInSlot() {
        return ItemStack.field_190927_a;
    }

    public boolean shouldUseOxygen() {
        return false;
    }

    public int getOxygenProvide(EnumFacing direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(600, this.getOxygenStored()) : 0;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockOxygenStorageModule) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockOxygenStorageModule.FACING);
        }
        return EnumFacing.NORTH;
    }

    public int func_70302_i_() {
        return this.getInventory().size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.getInventory().get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a((List)this.getInventory(), (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a((List)this.getInventory(), (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventory().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && itemstack != null && itemstack.func_77973_b() instanceof IItemOxygenSupply;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 && this.func_94041_b(slotID, itemstack)) {
            return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 && itemstack != null) {
            return FluidUtil.isEmptyContainer((ItemStack)itemstack);
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return super.canDrain(from, fluid);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return super.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return super.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return super.canFill(from, fluid);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return super.fill(from, resource, doFill);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return super.getTankInfo(from);
    }

    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.of(this.getFront().func_176746_e());
    }

    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.of(this.getFront().func_176735_f());
    }
}

