/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.helper.OptUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryUtils {
    public static Stream<ItemStack> stream(IInventory inv) {
        return IntStream.range(0, inv.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inv).func_70301_a(arg_0));
    }

    public static Stream<ItemStack> stream(IItemHandler inv) {
        return IntStream.range(0, inv.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inv).getStackInSlot(arg_0));
    }

    public static Stream<ItemStack> streamInventory(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return InventoryUtils.stream((IInventory)((EntityPlayer)entity).field_71071_by);
        }
        return OptUtils.capability((ICapabilityProvider)entity, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(InventoryUtils::stream).orElseGet(() -> StreamSupport.stream(entity.func_184209_aF().spliterator(), false));
    }

    public static void accrue(Accrue<ItemStack> accum, IItemHandler ... invs) {
        for (IItemHandler inv : invs) {
            InventoryUtils.stream(inv).forEach(accum);
        }
    }

    public static IItemHandlerModifiable restrict(IItemHandlerModifiable delegate, boolean allowInsert, boolean allowExtract) {
        return new RestrictedItemHandler(delegate, allowInsert, allowExtract);
    }

    @Deprecated
    public static IItemHandlerModifiable insertOnly(IItemHandlerModifiable delegate) {
        return InventoryUtils.restrict(delegate, true, false);
    }

    @Deprecated
    public static IItemHandlerModifiable extractOnly(IItemHandlerModifiable delegate) {
        return InventoryUtils.restrict(delegate, false, true);
    }

    public static IItemHandler join(IItemHandler ... handlers) {
        return InventoryUtils.join(Arrays.asList(handlers));
    }

    public static IItemHandler join(List<? extends IItemHandler> handlers) {
        return new AppendingItemHandler(handlers);
    }

    private static class AppendingItemHandler
    implements IItemHandler {
        private final List<DelegateSlot> slots = new ArrayList<DelegateSlot>();

        public AppendingItemHandler(List<? extends IItemHandler> delegates) {
            for (IItemHandler iItemHandler : delegates) {
                for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                    this.slots.add(new DelegateSlot(iItemHandler, i));
                }
            }
        }

        public int getSlots() {
            return this.slots.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.slots.get(slot).getStackInSlot();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.slots.get(slot).insertItem(stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.slots.get(slot).extractItem(amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.slots.get(slot).getSlotLimit();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.slots.get(slot).isItemValid(stack);
        }

        private static class DelegateSlot {
            private final IItemHandler delegate;
            private final int slotIndex;

            public DelegateSlot(IItemHandler delegate, int slotIndex) {
                this.delegate = delegate;
                this.slotIndex = slotIndex;
            }

            public ItemStack getStackInSlot() {
                return this.delegate.getStackInSlot(this.slotIndex);
            }

            public ItemStack insertItem(ItemStack stack, boolean simulate) {
                return this.delegate.insertItem(this.slotIndex, stack, simulate);
            }

            public ItemStack extractItem(int amount, boolean simulate) {
                return this.delegate.extractItem(this.slotIndex, amount, simulate);
            }

            public int getSlotLimit() {
                return this.delegate.getSlotLimit(this.slotIndex);
            }

            public boolean isItemValid(ItemStack stack) {
                return this.delegate.isItemValid(this.slotIndex, stack);
            }
        }
    }

    private static class RestrictedItemHandler
    implements IItemHandlerModifiable {
        private final IItemHandlerModifiable delegate;
        private final boolean allowInsert;
        private final boolean allowExtract;

        private RestrictedItemHandler(IItemHandlerModifiable delegate, boolean allowInsert, boolean allowExtract) {
            this.delegate = delegate;
            this.allowInsert = allowInsert;
            this.allowExtract = allowExtract;
        }

        public int getSlots() {
            return this.delegate.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.delegate.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.delegate.setStackInSlot(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.allowInsert ? this.delegate.insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.allowExtract ? this.delegate.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.delegate.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.delegate.isItemValid(slot, stack);
        }
    }
}

