/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render.shader;

import io.github.phantamanta44.libnine.util.render.shader.UniformType;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL20;

public class Uniform<T, C> {
    private final UniformType<T, C> type;
    private final String name;
    @Nullable
    private final C context;

    public Uniform(UniformType<T, C> type, String name) {
        this.type = type;
        this.name = name;
        this.context = type.generateContext();
    }

    public UniformType<T, C> getType() {
        return this.type;
    }

    public int computeLocation(int programId) {
        return GL20.glGetUniformLocation((int)programId, (CharSequence)this.name);
    }

    @Nullable
    public C getContext() {
        return this.context;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Uniform && this.name.equals(((Uniform)obj).name);
    }
}

