/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.variables;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.util.random.WeightedNBTTag;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigList;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.List;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class EntityData {
    public static boolean parseEntityList(ConfigValue entityEntry, List<WeightedNBTTag> list) {
        if (entityEntry.valueType() == ConfigValueType.LIST) {
            ConfigList blockList = (ConfigList)entityEntry;
            int e = blockList.size();
            for (int i = 0; i < e; ++i) {
                WeightedNBTTag entry = EntityData.parseEntityEntry((ConfigValue)blockList.get(i));
                if (entry == null) {
                    return false;
                }
                list.add(entry);
            }
        } else {
            WeightedNBTTag entry = EntityData.parseEntityEntry(entityEntry);
            if (entry == null) {
                return false;
            }
            list.add(entry);
        }
        return true;
    }

    public static WeightedNBTTag parseEntityEntry(ConfigValue entityEntry) {
        switch (entityEntry.valueType()) {
            case NULL: {
                CoFHWorld.log.warn("Null entity entry!");
                return null;
            }
            case OBJECT: {
                NBTTagCompound data;
                Config entityObject = ((ConfigObject)entityEntry).toConfig();
                if (entityObject.hasPath("spawner-tag")) {
                    try {
                        data = JsonToNBT.func_180713_a((String)entityObject.getString("spawner-tag"));
                    }
                    catch (NBTException e) {
                        CoFHWorld.log.error("Invalid `spawner-tag` value at line {}!", (Object)entityObject.getValue("spawner-tag").origin().lineNumber(), (Object)e);
                        return null;
                    }
                } else {
                    if (!entityObject.hasPath("entity")) {
                        CoFHWorld.log.error("`entity` or `spawner-tag` tag missing on object at line {}!", (Object)entityEntry.origin().lineNumber());
                        return null;
                    }
                    data = new NBTTagCompound();
                    String type = entityObject.getString("entity");
                    data.func_74778_a("EntityId", type);
                }
                int weight = entityObject.hasPath("weight") ? entityObject.getInt("weight") : 100;
                return new WeightedNBTTag(weight, (NBTBase)data);
            }
            case STRING: {
                String type = (String)entityEntry.unwrapped();
                if (type == null) {
                    CoFHWorld.log.error("Invalid entity entry!");
                    return null;
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("EntityId", type);
                return new WeightedNBTTag(100, (NBTBase)tag);
            }
        }
        CoFHWorld.log.warn("Invalid entity entry type at line {}", (Object)entityEntry.origin().lineNumber());
        return null;
    }
}

