/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.SaloonDoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class SaloonDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getClosedBoundingBox(DoorTileEntity te, boolean topBlock, BoundingBoxType type) {
        return this.getOpenBoundingBox(te, topBlock, type);
    }

    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity te, boolean topBlock, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION || te.isMoving()) {
            return null;
        }
        float f = 0.0625f;
        AxisAlignedBB aabb = type == BoundingBoxType.SELECTION ? new AxisAlignedBB(0.0, topBlock ? -0.75 : 0.25, (double)(0.5f - f / 2.0f), 1.0, topBlock ? 0.75 : 1.75, (double)(0.5f + f / 2.0f)) : new AxisAlignedBB(0.0, topBlock ? 0.0 : 0.25, (double)(0.5f - f / 2.0f), 1.0, topBlock ? 0.75 : 1.0, (double)(0.5f + f / 2.0f));
        return aabb;
    }

    private ChainedTransformation getTransformation(DoorTileEntity tileEntity) {
        float f = 0.0625f;
        float angle = -90.0f;
        float hingeX = 0.5f - f / 2.0f;
        if (tileEntity.isHingeLeft()) {
            angle = -angle;
        }
        if (((SaloonDoorTileEntity)tileEntity).isBackward()) {
            angle = -angle;
        }
        int t = tileEntity.getDescriptor().getOpeningTime() / 4;
        Rotation r1 = new Rotation(angle);
        r1.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r1.movement(1);
        r1.forTicks(t);
        Rotation r2 = new Rotation(-angle * 1.5f);
        r2.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r2.movement(1);
        r2.forTicks(t);
        Rotation r3 = new Rotation(angle * 0.75f);
        r3.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r3.movement(1);
        r3.forTicks(t);
        Rotation r4 = new Rotation(-angle * 0.25f);
        r4.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, 0.0f);
        r4.movement(1);
        r4.forTicks(t);
        ChainedTransformation ct = new ChainedTransformation(new Transformation[]{r1, r2, r3, r4});
        return ct;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, (Transformation)this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

