/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.romvoid95.api.config.annotation.GCTFeature;
import net.romvoid95.api.config.def.Category;
import net.romvoid95.api.config.values.OptArrayDouble;
import net.romvoid95.api.config.values.OptArrayInteger;
import net.romvoid95.api.config.values.OptArrayString;
import net.romvoid95.api.config.values.OptBoolean;
import net.romvoid95.api.config.values.OptDouble;
import net.romvoid95.api.config.values.OptInteger;
import net.romvoid95.api.config.values.OptString;
import net.romvoid95.api.config.values.OptValue;
import net.romvoid95.api.versioning.Version;
import net.romvoid95.galactic.core.GCTLog;

public abstract class ReadOnlyConfig {
    private File configFile;
    private ConfigVersion Configversion;
    private final Class<?> clazz;
    protected List<OptValue> properties = new ArrayList<OptValue>();
    protected List<Field> features = new ArrayList<Field>();
    protected List<String> propOrder = new ArrayList<String>();
    protected List<Category> configCats = new ArrayList<Category>();
    public static final Category FEATURES = Category.of("allfeatures").setRequiredRestarts(false, true);
    public static final Category FEATURE_OPTS = Category.of("featureopts");
    private Configuration config;

    protected ReadOnlyConfig(Class<?> clazz) {
        this.clazz = clazz;
        MinecraftForge.EVENT_BUS.register((Object)this);
        List<Field> subClazzFields = this.setFeatureFields(clazz.getDeclaredFields());
        subClazzFields.forEach(f -> this.addFeatOpt((Field)f));
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public ConfigVersion getConfigversion() {
        return this.Configversion;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    protected void setConfigversion(ConfigVersion configversion) {
        this.Configversion = configversion;
    }

    protected void addConfigCat(Category configCat) {
        this.configCats.add(configCat);
    }

    public boolean hasProperty(OptValue prop) {
        return this.properties.stream().anyMatch(property -> property.category().contentEquals(prop.category()) && property.key().contentEquals(prop.key()));
    }

    protected final OptBoolean addProperty(OptBoolean property) {
        this.addPropToList(property.key());
        this.addProp(property);
        return property;
    }

    protected final OptInteger addProperty(OptInteger property) {
        this.addPropToList(property.key());
        this.addProp(property);
        return property;
    }

    protected final OptString addProperty(OptString property) {
        this.addPropToList(property.key());
        this.addProp(property);
        return property;
    }

    protected final OptArrayInteger addProperty(OptArrayInteger property) {
        this.addPropToList(property.key());
        this.addProp(property);
        return property;
    }

    protected final OptArrayDouble addProperty(OptArrayDouble property) {
        this.addPropToList(property.key());
        this.addProp(property);
        return property;
    }

    protected final OptArrayString addProperty(OptArrayString property) {
        this.addPropToList(property.key());
        this.addProp(property);
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void loadConfig() {
        this.config = this.initConfig();
        try {
            this.config.load();
            for (Field field : this.features) {
                currFeature = field.getAnnotation(GCTFeature.class);
                key = currFeature.featureClass().getSimpleName().toLowerCase();
                try {
                    field.setBoolean(this.clazz, this.config.get(ReadOnlyConfig.FEATURES.get(), key, false).getBoolean());
                }
                catch (IllegalAccessException ex) {
                    GCTLog.error("Field \"{}\" is not accessible?", new Object[]{field.getName()});
                    GCTLog.catching(ex);
                }
            }
lbl14:
            // 11 sources

            block19: for (OptValue prop : this.properties) {
                try {
                    switch (1.$SwitchMap$net$romvoid95$api$config$values$OptValue$Type[prop.getType().ordinal()]) {
                        case 1: {
                            propInt = (OptInteger)prop;
                            intVal = propInt.hasRange() != false ? this.config.get(propInt.category(), propInt.key(), propInt.get(), propInt.comment(), propInt.min(), propInt.max()).setLanguageKey(propInt.langKey()).getInt() : this.config.get(propInt.category(), propInt.key(), propInt.get(), propInt.comment()).setLanguageKey(propInt.langKey()).getInt();
                            propInt.set(intVal);
                            ** break;
                        }
                        case 2: {
                            propIntArray = (OptArrayInteger)prop;
                            intArray = propIntArray.hasRange() != false ? this.config.get(propIntArray.category(), propIntArray.key(), propIntArray.get(), propIntArray.comment(), propIntArray.min(), propIntArray.max()).setLanguageKey(propIntArray.langKey()).getIntList() : this.config.get(propIntArray.category(), propIntArray.key(), propIntArray.get(), propIntArray.comment()).setLanguageKey(propIntArray.langKey()).getIntList();
                            propIntArray.set(intArray);
                            ** break;
                        }
                        case 3: {
                            propDouble = (OptDouble)prop;
                            doubleVal = propDouble.hasRange() != false ? this.config.get(propDouble.category(), propDouble.key(), propDouble.get(), propDouble.comment(), propDouble.min(), propDouble.max()).setLanguageKey(propDouble.langKey()).getDouble() : this.config.get(propDouble.category(), propDouble.key(), propDouble.get(), propDouble.comment()).setLanguageKey(propDouble.langKey()).getDouble();
                            propDouble.set(doubleVal);
                            ** break;
                        }
                        case 4: {
                            propDoubleArray = (OptArrayDouble)prop;
                            doubleArrayVal = propDoubleArray.hasRange() != false ? this.config.get(propDoubleArray.category(), propDoubleArray.key(), propDoubleArray.get(), propDoubleArray.comment(), propDoubleArray.min(), propDoubleArray.max()).setLanguageKey(propDoubleArray.langKey()).getDoubleList() : this.config.get(propDoubleArray.category(), propDoubleArray.key(), propDoubleArray.get(), propDoubleArray.comment()).setLanguageKey(propDoubleArray.langKey()).getDoubleList();
                            propDoubleArray.set(doubleArrayVal);
                            ** break;
                        }
                        case 5: {
                            propBool = (OptBoolean)prop;
                            propBool.set(this.config.getBoolean(propBool.key(), propBool.category(), propBool.get(), propBool.comment(), propBool.langKey()));
                            ** break;
                        }
                        case 6: {
                            propString = (OptString)prop;
                            Stringvalue = propString.needsValidation() != false ? this.config.getString(propString.key(), propString.category(), propString.get(), propString.comment(), propString.getValidValues(), propString.getValidValuesDisplay(), propString.langKey()) : this.config.getString(propString.key(), propString.category(), propString.get(), propString.comment(), propString.langKey());
                            propString.set(Stringvalue);
                            ** break;
                        }
                        case 7: {
                            propStringArray = (OptArrayString)prop;
                            propStringArray.set(this.config.get(propStringArray.category(), propStringArray.key(), propStringArray.get(), propStringArray.comment()).setLanguageKey(propStringArray.langKey()).getStringList());
                            continue block19;
                        }
                        ** default:
lbl51:
                        // 1 sources

                        continue block19;
                    }
                }
                catch (Exception e) {
                    GCTLog.error("Issue with Prop: {} of type {}", new Object[]{prop.key(), prop.getType().name()});
                    GCTLog.catching(e);
                }
                finally {
                    this.config.setCategoryPropertyOrder(prop.category(), this.propOrder);
                    this.config.setCategoryLanguageKey(prop.category(), prop.getConfigCat().getLangKey());
                    this.config.setCategoryRequiresMcRestart(prop.category(), prop.getConfigCat().requiresMCRestart);
                    this.config.setCategoryRequiresWorldRestart(prop.category(), prop.getConfigCat().requiresWorldRestart);
                }
            }
        }
        catch (Exception ignored) {
            GCTLog.error("Uh, we had a problem loading config: {}", new Object[]{this.config.getConfigFile()});
        }
        this.saveConfig();
    }

    protected Configuration initConfig() {
        return new Configuration(this.configFile, this.Configversion.toString());
    }

    protected void saveConfig() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration get() {
        return this.config;
    }

    public ConfigCategory getCategory(Category category) {
        return this.config.getCategory(category.get());
    }

    protected List<IConfigElement> getElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        ConfigCategory allFeatures = this.getCategory(FEATURES).setLanguageKey("galactictweaks.config.gui.cat.allfeatures");
        ConfigCategory featureOpts = this.getCategory(FEATURE_OPTS).setLanguageKey("galactictweaks.config.gui.cat.featureopts");
        list.add((IConfigElement)new ConfigElement(allFeatures));
        list.add((IConfigElement)new ConfigElement(featureOpts));
        return list;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("galactictweaks")) {
            this.saveConfig();
            this.loadConfig();
        }
    }

    private List<Field> setFeatureFields(Field[] fields) {
        ArrayList<Field> flds = new ArrayList<Field>();
        for (Field f : fields) {
            if (!f.isAnnotationPresent(GCTFeature.class)) continue;
            flds.add(f);
        }
        return flds;
    }

    private void addPropToList(String propName) {
        for (String name : this.propOrder) {
            if (!name.contentEquals(propName)) continue;
            this.propOrder.remove(name);
            break;
        }
        this.propOrder.add(propName);
    }

    private void addProp(OptValue property) {
        for (OptValue prop : this.properties) {
            if (!prop.key().contentEquals(property.key())) continue;
            this.properties.remove(prop);
            break;
        }
        this.properties.add(property);
    }

    private void addFeatOpt(Field feature) {
        for (Field feat : this.features) {
            if (!feat.getName().contentEquals(feature.getName())) continue;
            this.features.remove(feat);
            break;
        }
        this.features.add(feature);
    }

    public static class ConfigVersion
    extends Version {
        public static final ConfigVersion NULL_VERSION = new ConfigVersion("0.0.0");

        public ConfigVersion(String version) {
            super(version);
        }

        public ConfigVersion(Version version) {
            super(version.toString());
        }

        public ConfigVersion(int major, int minor, int patch, int build) {
            super(ConfigVersion.of(major) + "." + ConfigVersion.of(minor) + "." + ConfigVersion.of(patch) + "." + ConfigVersion.of(build));
        }

        private static String of(int val) {
            return String.valueOf(val);
        }

        public static boolean isVersionLessOrEqual(ConfigVersion comparate1, ConfigVersion comparate2) {
            Version c1 = new Version(comparate1.toString());
            Version c2 = new Version(comparate2.toString());
            return c1.isEqualTo(c2);
        }
    }
}

