/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.environmental;

import javax.annotation.Nonnull;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.environmental.CoolingSystemBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class AdvancedCoolingSystem
extends CoolingSystemBase {
    public AdvancedCoolingSystem(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        Fluid liquid_nitrogen = FluidRegistry.getFluid((String)"liquidnitrogen");
        if (liquid_nitrogen == null) {
            liquid_nitrogen = FluidRegistry.getFluid((String)"liquid_nitrogen");
        }
        if (liquid_nitrogen != null) {
            ItemStack nitrogenBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(liquid_nitrogen, 1000));
            ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)nitrogenBucket, (int)1));
        }
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.rubberHose, (int)2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.controlCircuit, (int)1));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.computerChip, (int)2));
        this.addTradeoffPropertyDouble("advancedCoolingPower", "coolingBonus", 7.0, "%");
        this.addTradeoffPropertyDouble("advancedCoolingPower", "advCoolSysEnergyCon", 160.0, "RF/t");
    }

    @Override
    public double getCoolingFactor() {
        return 2.1;
    }

    @Override
    public double getCoolingBonus(@Nonnull ItemStack itemStack) {
        return ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "coolingBonus");
    }

    @Override
    public double getEnergyConsumption(@Nonnull ItemStack itemStack) {
        return ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "advCoolSysEnergyCon");
    }

    @Override
    public String getDataName() {
        return "advancedCoolingSystem";
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.advancedCoolingSystem;
    }
}

