/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.item.IFlowerlessBiome;
import vazkii.botania.api.item.IFlowerlessWorld;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;

public final class BiomeDecorationHandler {
    private BiomeDecorationHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        BlockPos pos;
        BlockPos blockPos = pos = event.getPlacementPos() != null ? event.getPlacementPos() : event.getChunkPos().func_180331_a(0, 0, 0);
        if ((event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT) && event.getType() == DecorateBiomeEvent.Decorate.EventType.FLOWERS) {
            int y;
            int z;
            int x;
            int i;
            boolean flowers = true;
            if (event.getWorld().field_73011_w instanceof IFlowerlessWorld) {
                flowers = ((IFlowerlessWorld)event.getWorld().field_73011_w).generateFlowers(event.getWorld());
            } else if (event.getWorld().func_180494_b(pos) instanceof IFlowerlessBiome) {
                flowers = ((IFlowerlessBiome)event.getWorld().func_180494_b(pos)).canGenerateFlowers(event.getWorld(), pos.func_177958_n(), pos.func_177952_p());
            }
            if (!flowers) {
                return;
            }
            int dist = Math.min(8, Math.max(1, ConfigHandler.flowerPatchSize));
            for (i = 0; i < ConfigHandler.flowerQuantity; ++i) {
                if (event.getRand().nextInt(ConfigHandler.flowerPatchChance) != 0) continue;
                x = pos.func_177958_n() + event.getRand().nextInt(16) + 8;
                z = pos.func_177952_p() + event.getRand().nextInt(16) + 8;
                y = event.getWorld().func_175672_r(pos).func_177956_o();
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)event.getRand().nextInt(16));
                for (int j = 0; j < ConfigHandler.flowerDensity * ConfigHandler.flowerPatchChance; ++j) {
                    int x1 = x + event.getRand().nextInt(dist * 2) - dist;
                    int y1 = y + event.getRand().nextInt(4) - event.getRand().nextInt(4);
                    int z1 = z + event.getRand().nextInt(dist * 2) - dist;
                    BlockPos pos2 = new BlockPos(x1, y1, z1);
                    if (!event.getWorld().func_175623_d(pos2) || event.getWorld().field_73011_w.func_177495_o() && y1 >= 127 || !ModBlocks.flower.func_176196_c(event.getWorld(), pos2)) continue;
                    event.getWorld().func_180501_a(pos2, ModBlocks.flower.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)color), 2);
                    if (!(event.getRand().nextDouble() < ConfigHandler.flowerTallChance) || !((BlockModFlower)ModBlocks.flower).func_176473_a(event.getWorld(), pos2, event.getWorld().func_180495_p(pos2), false)) continue;
                    BlockModFlower.placeDoubleFlower(event.getWorld(), pos2, color, 0);
                }
            }
            for (i = 0; i < ConfigHandler.mushroomQuantity; ++i) {
                x = pos.func_177958_n() + event.getRand().nextInt(16) + 8;
                z = pos.func_177952_p() + event.getRand().nextInt(16) + 8;
                y = event.getRand().nextInt(26) + 4;
                BlockPos pos3 = new BlockPos(x, y, z);
                EnumDyeColor color = EnumDyeColor.func_176764_b((int)event.getRand().nextInt(16));
                if (!event.getWorld().func_175623_d(pos3) || !ModBlocks.mushroom.func_176196_c(event.getWorld(), pos3)) continue;
                event.getWorld().func_180501_a(pos3, ModBlocks.mushroom.func_176223_P().func_177226_a(BotaniaStateProps.COLOR, (Comparable)color), 2);
            }
        }
    }
}

