/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.storage;

import java.util.BitSet;
import java.util.Map;
import net.minecraft.nbt.NBTTagIntArray;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepaireProgress;
import pregenerator.impl.storage.PregenTask;

public class MassCircleTask
extends PregenTask {
    int centerX;
    int centerZ;
    int radius;

    public MassCircleTask(int ... data) {
        this(data[0] == 3, data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8], data[9]);
    }

    public MassCircleTask(boolean type, int dimID, int minX, int minZ, int maxX, int maxZ, int centerX, int centerZ, int radius, int post) {
        super(type ? 3 : 2, dimID, minX, minZ, maxX, maxZ, post);
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.radius = radius;
    }

    @Override
    public NBTTagIntArray save() {
        return new NBTTagIntArray(new int[]{this.type, this.dimension, this.middleX, this.middleZ, this.radiusX, this.radiusZ, this.postProcessing, this.centerX, this.centerZ, this.radius});
    }

    @Override
    public long getTaskSizes() {
        if (this.type == 2) {
            return (this.radiusX - this.middleX) * (this.radiusZ - this.middleZ);
        }
        return (long)((double)((long)this.radius * 2L) * Math.PI);
    }

    @Override
    protected Map<Long, BitSet> makeTask(PrepaireProgress progress) {
        if (this.type == 2) {
            return ChunkCalculator.createArea(this.middleX, this.middleZ, this.radiusX, this.radiusZ, progress);
        }
        return ChunkCalculator.createCircleArea(this.middleX, this.middleZ, this.radiusX, this.radiusZ, this.centerX, this.centerZ, this.radius, progress);
    }
}

