/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableArmorStandData;
import org.spongepowered.api.data.manipulator.mutable.entity.ArmorStandData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeArmorStandData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeArmorStandData
extends AbstractData<ArmorStandData, ImmutableArmorStandData>
implements ArmorStandData {
    private boolean marker;
    private boolean small;
    private boolean arms;
    private boolean basePlate;

    public SpongeArmorStandData() {
        this(false, false, false, true);
    }

    public SpongeArmorStandData(boolean marker, boolean small, boolean arms, boolean basePlate) {
        super(ArmorStandData.class);
        this.marker = marker;
        this.small = small;
        this.arms = arms;
        this.basePlate = basePlate;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.ARMOR_STAND_HAS_ARMS, () -> this.arms);
        this.registerFieldSetter(Keys.ARMOR_STAND_HAS_ARMS, hasArms -> {
            this.arms = hasArms;
        });
        this.registerKeyValue(Keys.ARMOR_STAND_HAS_ARMS, this::arms);
        this.registerFieldGetter(Keys.ARMOR_STAND_IS_SMALL, () -> this.small);
        this.registerFieldSetter(Keys.ARMOR_STAND_IS_SMALL, small -> {
            this.small = small;
        });
        this.registerKeyValue(Keys.ARMOR_STAND_IS_SMALL, this::small);
        this.registerFieldGetter(Keys.ARMOR_STAND_HAS_BASE_PLATE, () -> this.basePlate);
        this.registerFieldSetter(Keys.ARMOR_STAND_HAS_BASE_PLATE, basePlate -> {
            this.basePlate = basePlate;
        });
        this.registerKeyValue(Keys.ARMOR_STAND_HAS_BASE_PLATE, this::basePlate);
        this.registerFieldGetter(Keys.ARMOR_STAND_MARKER, () -> this.marker);
        this.registerFieldSetter(Keys.ARMOR_STAND_MARKER, marker -> {
            this.marker = marker;
        });
        this.registerKeyValue(Keys.ARMOR_STAND_MARKER, this::marker);
    }

    @Override
    public Value<Boolean> marker() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_MARKER, false, this.marker);
    }

    @Override
    public Value<Boolean> small() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_IS_SMALL, false, this.small);
    }

    @Override
    public Value<Boolean> arms() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_HAS_ARMS, false, this.arms);
    }

    @Override
    public Value<Boolean> basePlate() {
        return new SpongeValue<Boolean>(Keys.ARMOR_STAND_HAS_BASE_PLATE, true, this.basePlate);
    }

    @Override
    public ArmorStandData copy() {
        return new SpongeArmorStandData(this.marker, this.small, this.arms, this.basePlate);
    }

    @Override
    public ImmutableArmorStandData asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeArmorStandData.class, this.marker, this.small, this.arms, this.basePlate);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.ARMOR_STAND_HAS_ARMS, (Object)this.arms).set(Keys.ARMOR_STAND_HAS_BASE_PLATE, (Object)this.basePlate).set(Keys.ARMOR_STAND_IS_SMALL, (Object)this.small).set(Keys.ARMOR_STAND_MARKER, (Object)this.marker);
    }
}

