/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableStatisticData;
import org.spongepowered.api.data.manipulator.mutable.entity.StatisticData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeStatisticData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractMappedData;

public class SpongeStatisticData
extends AbstractMappedData<Statistic, Long, StatisticData, ImmutableStatisticData>
implements StatisticData {
    public SpongeStatisticData(Map<Statistic, Long> value) {
        super(StatisticData.class, value, Keys.STATISTICS, ImmutableSpongeStatisticData.class);
    }

    public SpongeStatisticData() {
        this(Maps.newHashMap());
    }

    @Override
    public Optional<Long> get(Statistic key) {
        return Optional.ofNullable(this.getValue().get(key));
    }

    @Override
    public Set<Statistic> getMapKeys() {
        return this.getValue().keySet();
    }

    @Override
    public StatisticData put(Statistic key, Long value) {
        return this.withMap(map -> map.put(key, value));
    }

    @Override
    public StatisticData putAll(Map<? extends Statistic, ? extends Long> map) {
        return this.withMap(value -> value.putAll(map));
    }

    @Override
    public StatisticData remove(Statistic key) {
        return this.withMap(map -> {
            Long cfr_ignored_0 = (Long)map.remove(key);
        });
    }

    private StatisticData withMap(Consumer<Map<Statistic, Long>> c) {
        Object value = this.getValue();
        c.accept((Map<Statistic, Long>)value);
        return (StatisticData)this.setValue(value);
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public Optional<StatisticData> fill(DataHolder dataHolder, MergeFunction overlap) {
        SpongeStatisticData replacement = dataHolder.get(Keys.STATISTICS).map(SpongeStatisticData::new).orElse(null);
        return Optional.of(overlap.merge(this, replacement));
    }

    @Override
    public Optional<StatisticData> from(DataContainer container) {
        Optional<Map<?, ?>> value = container.getMap(Keys.STATISTICS.getQuery());
        if (!value.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new SpongeStatisticData(value.get()));
    }

    @Override
    public StatisticData copy() {
        return new SpongeStatisticData((Map<Statistic, Long>)this.getValue());
    }

    @Override
    public ImmutableStatisticData asImmutable() {
        return new ImmutableSpongeStatisticData((Map<Statistic, Long>)this.getValue());
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.STATISTICS, this.getValue());
    }
}

