/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.item;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableHideData;
import org.spongepowered.api.data.manipulator.mutable.item.HideData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.item.ImmutableSpongeHideData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeHideData
extends AbstractData<HideData, ImmutableHideData>
implements HideData {
    private boolean enchantments;
    private boolean attributes;
    private boolean unbreakable;
    private boolean canDestroy;
    private boolean canPlace;
    private boolean miscellaneous;

    public SpongeHideData(boolean enchantments, boolean attributes, boolean unbreakable, boolean canDestroy, boolean canPlace, boolean miscellaneous) {
        super(HideData.class);
        this.enchantments = enchantments;
        this.attributes = attributes;
        this.unbreakable = unbreakable;
        this.canDestroy = canDestroy;
        this.canPlace = canPlace;
        this.miscellaneous = miscellaneous;
        this.registerGettersAndSetters();
    }

    public SpongeHideData() {
        this(false, false, false, false, false, false);
    }

    @Override
    public Value<Boolean> hideEnchantments() {
        return SpongeValueFactory.getInstance().createValue(Keys.HIDE_ENCHANTMENTS, this.enchantments, false);
    }

    @Override
    public Value<Boolean> hideAttributes() {
        return SpongeValueFactory.getInstance().createValue(Keys.HIDE_ATTRIBUTES, this.attributes, false);
    }

    @Override
    public Value<Boolean> hideUnbreakable() {
        return SpongeValueFactory.getInstance().createValue(Keys.HIDE_UNBREAKABLE, this.unbreakable, false);
    }

    @Override
    public Value<Boolean> hideCanDestroy() {
        return SpongeValueFactory.getInstance().createValue(Keys.HIDE_CAN_DESTROY, this.canDestroy, false);
    }

    @Override
    public Value<Boolean> hideCanPlace() {
        return SpongeValueFactory.getInstance().createValue(Keys.HIDE_CAN_PLACE, this.canPlace, false);
    }

    @Override
    public Value<Boolean> hideMiscellaneous() {
        return SpongeValueFactory.getInstance().createValue(Keys.HIDE_MISCELLANEOUS, this.miscellaneous, false);
    }

    @Override
    public HideData copy() {
        return new SpongeHideData(this.enchantments, this.attributes, this.unbreakable, this.canDestroy, this.canPlace, this.miscellaneous);
    }

    @Override
    public ImmutableHideData asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeHideData.class, this.enchantments, this.attributes, this.unbreakable, this.canDestroy, this.canPlace, this.miscellaneous);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.HIDE_ENCHANTMENTS, (Object)this.enchantments).set(Keys.HIDE_ATTRIBUTES, (Object)this.attributes).set(Keys.HIDE_UNBREAKABLE, (Object)this.unbreakable).set(Keys.HIDE_CAN_DESTROY, (Object)this.canDestroy).set(Keys.HIDE_CAN_PLACE, (Object)this.canPlace).set(Keys.HIDE_MISCELLANEOUS, (Object)this.miscellaneous);
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.HIDE_ENCHANTMENTS, this::isEnchantments);
        this.registerFieldSetter(Keys.HIDE_ENCHANTMENTS, this::setEnchantments);
        this.registerKeyValue(Keys.HIDE_ENCHANTMENTS, this::hideEnchantments);
        this.registerFieldGetter(Keys.HIDE_ATTRIBUTES, this::isAttributes);
        this.registerFieldSetter(Keys.HIDE_ATTRIBUTES, this::setAttributes);
        this.registerKeyValue(Keys.HIDE_ATTRIBUTES, this::hideAttributes);
        this.registerFieldGetter(Keys.HIDE_UNBREAKABLE, this::isUnbreakable);
        this.registerFieldSetter(Keys.HIDE_UNBREAKABLE, this::setUnbreakable);
        this.registerKeyValue(Keys.HIDE_UNBREAKABLE, this::hideUnbreakable);
        this.registerFieldGetter(Keys.HIDE_CAN_DESTROY, this::isCanDestroy);
        this.registerFieldSetter(Keys.HIDE_CAN_DESTROY, this::setCanDestroy);
        this.registerKeyValue(Keys.HIDE_CAN_DESTROY, this::hideCanDestroy);
        this.registerFieldGetter(Keys.HIDE_CAN_PLACE, this::isCanPlace);
        this.registerFieldSetter(Keys.HIDE_CAN_PLACE, this::setCanPlace);
        this.registerKeyValue(Keys.HIDE_CAN_PLACE, this::hideCanPlace);
        this.registerFieldGetter(Keys.HIDE_MISCELLANEOUS, this::isMiscellaneous);
        this.registerFieldSetter(Keys.HIDE_MISCELLANEOUS, this::setMiscellaneous);
        this.registerKeyValue(Keys.HIDE_MISCELLANEOUS, this::hideMiscellaneous);
    }

    public boolean isEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(boolean enchantments) {
        this.enchantments = enchantments;
    }

    public boolean isAttributes() {
        return this.attributes;
    }

    public void setAttributes(boolean attributes) {
        this.attributes = attributes;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean isCanDestroy() {
        return this.canDestroy;
    }

    public void setCanDestroy(boolean canDestroy) {
        this.canDestroy = canDestroy;
    }

    public boolean isCanPlace() {
        return this.canPlace;
    }

    public void setCanPlace(boolean canPlace) {
        this.canPlace = canPlace;
    }

    public boolean isMiscellaneous() {
        return this.miscellaneous;
    }

    public void setMiscellaneous(boolean miscellaneous) {
        this.miscellaneous = miscellaneous;
    }
}

