/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.extra.fluid;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.extra.fluid.FluidStack;
import org.spongepowered.api.extra.fluid.FluidStackSnapshot;
import org.spongepowered.api.extra.fluid.FluidType;
import org.spongepowered.common.extra.fluid.SpongeFluidStack;
import org.spongepowered.common.extra.fluid.SpongeFluidStackSnapshot;
import org.spongepowered.common.util.Constants;

public class SpongeFluidStackBuilder
extends AbstractDataBuilder<FluidStack>
implements FluidStack.Builder {
    FluidType fluidType;
    int volume = 1;
    @Nullable
    DataContainer extra;

    public SpongeFluidStackBuilder() {
        super(FluidStack.class, 1);
    }

    @Override
    public FluidStack.Builder fluid(FluidType fluidType) {
        this.fluidType = (FluidType)Preconditions.checkNotNull((Object)fluidType, (Object)"FluidType cannot be null!");
        return this;
    }

    @Override
    public FluidStack.Builder volume(int volume) {
        Preconditions.checkArgument((volume > 0 ? 1 : 0) != 0, (Object)"A FluidStack's volume has to be greater than zero!");
        this.volume = volume;
        return this;
    }

    @Override
    public FluidStack.Builder from(FluidStackSnapshot fluidStackSnapshot) {
        Preconditions.checkArgument((boolean)(fluidStackSnapshot instanceof SpongeFluidStackSnapshot), (Object)"Invalid implementation found of FluidStackSnapshot!");
        this.fluidType = fluidStackSnapshot.getFluid();
        this.volume = fluidStackSnapshot.getVolume();
        DataContainer container = fluidStackSnapshot.toContainer();
        if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
            this.extra = container.getView(Constants.Sponge.UNSAFE_NBT).get().copy();
        }
        return this;
    }

    @Override
    public FluidStack build() {
        Preconditions.checkNotNull((Object)this.fluidType, (Object)"Fluidtype cannot be null!");
        Preconditions.checkState((this.volume >= 0 ? 1 : 0) != 0, (Object)"Volume must be at least zero!");
        return new SpongeFluidStack(this);
    }

    @Override
    public FluidStack.Builder from(FluidStack value) {
        this.fluidType = value.getFluid();
        this.volume = value.getVolume();
        DataContainer container = value.toContainer();
        if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
            this.extra = container.getView(Constants.Sponge.UNSAFE_NBT).get().copy();
        }
        return this;
    }

    @Override
    protected Optional<FluidStack> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Fluids.FLUID_TYPE, Constants.Fluids.FLUID_VOLUME)) {
            return Optional.empty();
        }
        this.reset();
        String fluidId = container.getString(Constants.Fluids.FLUID_TYPE).get();
        Optional<FluidType> fluidType = Sponge.getRegistry().getType(FluidType.class, fluidId);
        if (!fluidType.isPresent()) {
            throw new InvalidDataException("Invalid fluid id found: " + fluidId);
        }
        this.fluidType = fluidType.get();
        this.volume = container.getInt(Constants.Fluids.FLUID_VOLUME).get();
        this.extra = container.contains(Constants.Sponge.UNSAFE_NBT) ? container.getView(Constants.Sponge.UNSAFE_NBT).get().copy() : null;
        return Optional.of(this.build());
    }

    @Override
    public FluidStack.Builder reset() {
        this.fluidType = null;
        this.volume = 0;
        this.extra = null;
        return this;
    }
}

