/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.passive.EntityVillager;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.item.merchant.TradeOfferListMutator;
import org.spongepowered.api.item.merchant.VillagerRegistry;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeProfession;
import org.spongepowered.common.mixin.core.entity.passive.EntityVillagerAccessor;
import org.spongepowered.common.registry.type.entity.CareerRegistryModule;

public final class SpongeVillagerRegistry
implements VillagerRegistry {
    private final Map<Career, Multimap<Integer, TradeOfferListMutator>> careerGeneratorMap = new HashMap<Career, Multimap<Integer, TradeOfferListMutator>>();

    public static SpongeVillagerRegistry getInstance() {
        return Holder.INSTANCE;
    }

    SpongeVillagerRegistry() {
    }

    @Override
    public Multimap<Integer, TradeOfferListMutator> getTradeOfferLevelMap(Career career) {
        Multimap<Integer, TradeOfferListMutator> multimap = this.careerGeneratorMap.get(Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!"));
        if (multimap == null) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.copyOf(multimap);
    }

    @Override
    public VillagerRegistry addMutator(Career career, int level, TradeOfferListMutator generator) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull((Object)generator, (Object)"Generator cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)3);
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.put((Object)level, (Object)generator);
        return this;
    }

    @Override
    public VillagerRegistry addMutators(Career career, int level, TradeOfferListMutator generator, TradeOfferListMutator ... generators) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull((Object)generator, (Object)"Generator cannot be null!");
        Preconditions.checkNotNull((Object)generators, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(generator);
        for (TradeOfferListMutator element : generators) {
            list.add(Preconditions.checkNotNull((Object)element, (Object)"TradeOfferListMutator cannot be null!"));
        }
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)list.size());
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.putAll((Object)level, list);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(Career career, int level, List<TradeOfferListMutator> generators) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Career level must be at least greater than zero!");
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull(generators, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap == null) {
            multimap = ArrayListMultimap.create((int)3, (int)generators.size());
            this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        }
        multimap.replaceValues((Object)level, generators);
        return this;
    }

    @Override
    public VillagerRegistry setMutators(Career career, Multimap<Integer, TradeOfferListMutator> generatorMap) {
        Preconditions.checkNotNull((Object)career, (Object)"Career cannot be null!");
        Preconditions.checkNotNull(generatorMap, (Object)"Generators cannot be null!");
        ArrayListMultimap multimap = this.careerGeneratorMap.get(career);
        if (multimap != null) {
            multimap.clear();
        }
        multimap = ArrayListMultimap.create(generatorMap);
        this.careerGeneratorMap.put(career, (Multimap<Integer, TradeOfferListMutator>)multimap);
        return this;
    }

    static void registerVanillaTrades() {
        SpongeVillagerRegistry instance = SpongeVillagerRegistry.getInstance();
        for (Career career : CareerRegistryModule.getInstance().getAll()) {
            SpongeCareer spongeCareer = (SpongeCareer)career;
            EntityVillager.ITradeList[][] careerLevels = EntityVillagerAccessor.accessor$getDefaultTradeListMapping()[((SpongeProfession)spongeCareer.getProfession()).type][spongeCareer.type];
            for (int level = 0; level < careerLevels.length; ++level) {
                EntityVillager.ITradeList[] offers = careerLevels[level];
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < offers.length; ++i) {
                    builder.add((Object)SpongeVillagerRegistry.generatorFor(offers[i]));
                }
                instance.setMutators(career, level + 1, (List<TradeOfferListMutator>)builder.build());
            }
        }
    }

    private static TradeOfferListMutator generatorFor(EntityVillager.ITradeList iTradeList) {
        return (TradeOfferListMutator)iTradeList;
    }

    static final class Holder {
        static final SpongeVillagerRegistry INSTANCE = new SpongeVillagerRegistry();

        Holder() {
        }
    }
}

