/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseStyles;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.SpongeHorseStyle;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=HorseStyles.class)
public class HorseStyleRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<HorseStyle> {
    public static final SpongeHorseStyle WHITE_STYLE = new SpongeHorseStyle(1, "minecraft:white", "WHITE");
    public static final SpongeHorseStyle WHITEFIELD = new SpongeHorseStyle(2, "minecraft:whitefield", "WHITEFIELD");
    public static final SpongeHorseStyle WHITE_DOTS = new SpongeHorseStyle(3, "minecraft:white_dots", "WHITE_DOTS");
    public static final SpongeHorseStyle BLACK_DOTS = new SpongeHorseStyle(4, "minecraft:black_dots", "BLACK_DOTS");
    public static final SpongeHorseStyle NONE = new SpongeHorseStyle(0, "minecraft:none", "NONE");
    public static final Int2ObjectMap<HorseStyle> HORSE_STYLE_IDMAP = new Int2ObjectOpenHashMap();
    private static final HorseStyleRegistryModule INSTANCE = new HorseStyleRegistryModule();

    private HorseStyleRegistryModule() {
        super("minecraft");
    }

    public static HorseStyle getHorseStyle(EntityHorse horse) {
        return (HorseStyle)HORSE_STYLE_IDMAP.get((horse.func_110202_bQ() & 0xFF00) >> 8);
    }

    public static HorseStyle getHorseStyle(DataView container) {
        return SpongeImpl.getRegistry().getType(HorseStyle.class, DataUtil.getData(container, Keys.HORSE_STYLE, String.class)).get();
    }

    public static HorseStyleRegistryModule getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerDefaults() {
        this.register(NONE);
        this.register(WHITE_STYLE);
        this.register(WHITEFIELD);
        this.register(WHITE_DOTS);
        this.register(BLACK_DOTS);
        HORSE_STYLE_IDMAP.put(0, (Object)NONE);
        HORSE_STYLE_IDMAP.put(1, (Object)WHITE_STYLE);
        HORSE_STYLE_IDMAP.put(2, (Object)WHITEFIELD);
        HORSE_STYLE_IDMAP.put(3, (Object)WHITE_DOTS);
        HORSE_STYLE_IDMAP.put(4, (Object)BLACK_DOTS);
    }
}

