/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import betterquesting.api.utils.NBTConverter;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StringUtils;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class ItemComparison {
    public static boolean StackMatch(ItemStack stack1, ItemStack stack2, boolean nbtCheck, boolean partialNBT) {
        if (stack1 == stack2) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (nbtCheck) {
            if (!partialNBT && !stack1.areCapsCompatible(stack2)) {
                return false;
            }
            if (!ItemComparison.CompareNBTTag((NBTBase)stack1.func_77978_p(), (NBTBase)stack2.func_77978_p(), partialNBT)) {
                return false;
            }
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == stack2.func_77952_i() || stack1.func_77973_b().func_77645_m() || stack1.func_77952_i() == Short.MAX_VALUE);
    }

    public static boolean CompareNBTTag(NBTBase tag1, NBTBase tag2, boolean partial) {
        if (ItemComparison.isEmptyNBT(tag1) != ItemComparison.isEmptyNBT(tag2)) {
            return false;
        }
        if (ItemComparison.isEmptyNBT(tag1)) {
            return true;
        }
        if (!(tag1 instanceof NBTPrimitive && tag2 instanceof NBTPrimitive || tag1.func_74732_a() == tag2.func_74732_a())) {
            return false;
        }
        if (tag1 instanceof NBTTagCompound && tag2 instanceof NBTTagCompound) {
            return ItemComparison.CompareNBTTagCompound((NBTTagCompound)tag1, (NBTTagCompound)tag2, partial);
        }
        if (tag1 instanceof NBTTagList && tag2 instanceof NBTTagList) {
            NBTTagList list1 = (NBTTagList)tag1;
            NBTTagList list2 = (NBTTagList)tag2;
            if (list1.func_74745_c() > list2.func_74745_c() || !partial && list1.func_74745_c() != list2.func_74745_c()) {
                return false;
            }
            block0: for (int i = 0; i < list1.func_74745_c(); ++i) {
                NBTBase lt1 = list1.func_179238_g(i);
                for (int j = 0; j < list2.func_74745_c(); ++j) {
                    if (ItemComparison.CompareNBTTag(lt1, list2.func_179238_g(j), partial)) continue block0;
                }
                return false;
            }
        } else {
            if (tag1 instanceof NBTTagIntArray && tag2 instanceof NBTTagIntArray) {
                NBTTagIntArray list1 = (NBTTagIntArray)tag1;
                NBTTagIntArray list2 = (NBTTagIntArray)tag2;
                if (list1.func_150302_c().length > list2.func_150302_c().length || !partial && list1.func_150302_c().length != list2.func_150302_c().length) {
                    return false;
                }
                ArrayList<Integer> usedIdxs = new ArrayList<Integer>();
                for (int i = 0; i < list1.func_150302_c().length; ++i) {
                    int j;
                    block29: {
                        for (j = 0; j < list2.func_150302_c().length; ++j) {
                            if (usedIdxs.contains(j) || list1.func_150302_c()[i] != list2.func_150302_c()[j]) {
                                continue;
                            }
                            break block29;
                        }
                        return false;
                    }
                    usedIdxs.add(j);
                }
                return true;
            }
            if (tag1 instanceof NBTTagByteArray && tag2 instanceof NBTTagByteArray) {
                NBTTagByteArray list1 = (NBTTagByteArray)tag1;
                NBTTagByteArray list2 = (NBTTagByteArray)tag2;
                if (list1.func_150292_c().length > list2.func_150292_c().length || !partial && list1.func_150292_c().length != list2.func_150292_c().length) {
                    return false;
                }
                ArrayList<Integer> usedIdxs = new ArrayList<Integer>();
                for (int i = 0; i < list1.func_150292_c().length; ++i) {
                    int j;
                    block30: {
                        for (j = 0; j < list2.func_150292_c().length; ++j) {
                            if (usedIdxs.contains(j) || list1.func_150292_c()[i] != list2.func_150292_c()[j]) {
                                continue;
                            }
                            break block30;
                        }
                        return false;
                    }
                    usedIdxs.add(j);
                }
            } else if (tag1 instanceof NBTTagLongArray && tag2 instanceof NBTTagLongArray) {
                long[] la2;
                NBTTagLongArray list1 = (NBTTagLongArray)tag1;
                NBTTagLongArray list2 = (NBTTagLongArray)tag2;
                long[] la1 = NBTConverter.readLongArray(list1);
                if (la1.length > (la2 = NBTConverter.readLongArray(list2)).length || !partial && la1.length != la2.length) {
                    return false;
                }
                ArrayList<Integer> usedIdxs = new ArrayList<Integer>();
                for (long l : la1) {
                    int j;
                    block31: {
                        for (j = 0; j < la2.length; ++j) {
                            if (usedIdxs.contains(j) || l != la2[j]) {
                                continue;
                            }
                            break block31;
                        }
                        return false;
                    }
                    usedIdxs.add(j);
                }
            } else {
                if (tag1 instanceof NBTTagString && tag2 instanceof NBTTagString) {
                    return tag1.equals((Object)tag2);
                }
                if (tag1 instanceof NBTPrimitive && tag2 instanceof NBTPrimitive) {
                    Number num1 = NBTConverter.getNumber(tag1);
                    Number num2 = NBTConverter.getNumber(tag2);
                    if (tag1 instanceof NBTTagFloat || tag1 instanceof NBTTagDouble || tag2 instanceof NBTTagFloat || tag2 instanceof NBTTagDouble) {
                        return num1.doubleValue() == num2.doubleValue();
                    }
                    return num1.longValue() == num2.longValue();
                }
                return tag1.equals((Object)tag2);
            }
        }
        return true;
    }

    private static boolean CompareNBTTagCompound(NBTTagCompound reqTags, NBTTagCompound sample, boolean partial) {
        if (ItemComparison.isEmptyNBT((NBTBase)reqTags) != ItemComparison.isEmptyNBT((NBTBase)sample)) {
            return false;
        }
        if (ItemComparison.isEmptyNBT((NBTBase)reqTags)) {
            return true;
        }
        for (String key : reqTags.func_150296_c()) {
            if (!sample.func_74764_b(key)) {
                return false;
            }
            if (ItemComparison.CompareNBTTag(reqTags.func_74781_a(key), sample.func_74781_a(key), partial)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmptyNBT(NBTBase tag) {
        return tag == null || tag.func_82582_d();
    }

    @Deprecated
    public static boolean OreDictionaryMatch(String name, ItemStack stack) {
        return stack != null && !StringUtils.func_151246_b((String)name) && new OreIngredient(name).apply(stack);
    }

    @Deprecated
    public static boolean OreDictionaryMatch(String name, NBTTagCompound tags, ItemStack stack, boolean nbtCheck, boolean partialNBT) {
        if (!nbtCheck) {
            return stack != null && !StringUtils.func_151246_b((String)name) && new OreIngredient(name).apply(stack);
        }
        return ItemComparison.OreDictionaryMatch(new OreIngredient(name), tags, stack, nbtCheck, partialNBT);
    }

    public static boolean OreDictionaryMatch(OreIngredient ore, NBTTagCompound tags, ItemStack stack, boolean nbtCheck, boolean partialNBT) {
        if (stack == null || ore == null) {
            return false;
        }
        return ore.apply(stack) && (!nbtCheck || ItemComparison.CompareNBTTagCompound(stack.func_77978_p(), tags, partialNBT));
    }

    @Deprecated
    public static boolean AllMatch(ItemStack stack1, ItemStack stack2) {
        return ItemComparison.AllMatch(stack1, stack2, false, false);
    }

    public static boolean AllMatch(ItemStack stack1, ItemStack stack2, boolean nbtCheck, boolean partialNBT) {
        if (stack1 == stack2) {
            return true;
        }
        if (stack1 == null) {
            return false;
        }
        if (nbtCheck && !ItemComparison.CompareNBTTagCompound(stack1.func_77978_p(), stack2.func_77978_p(), partialNBT)) {
            return false;
        }
        if (ItemComparison.StackMatch(stack1, stack2, false, false)) {
            return true;
        }
        int[] oreIDs1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] oreIDs2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i1 : oreIDs1) {
            for (int i2 : oreIDs2) {
                if (i1 != i2) continue;
                return true;
            }
        }
        return false;
    }
}

