/*
 * Decompiled with CFR 0.152.
 */
package flavor.pie.itemchat;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import flavor.pie.itemchat.Config;
import flavor.pie.itemchat.ItemChat;
import flavor.pie.itemchat.ItemChatKt;
import flavor.pie.itemchat.runtime.kotlin.Metadata;
import flavor.pie.itemchat.runtime.kotlin.TuplesKt;
import flavor.pie.itemchat.runtime.kotlin.TypeCastException;
import flavor.pie.itemchat.runtime.kotlin.collections.CollectionsKt;
import flavor.pie.itemchat.runtime.kotlin.collections.MapsKt;
import flavor.pie.itemchat.runtime.kotlin.jvm.functions.Function1;
import flavor.pie.itemchat.runtime.kotlin.jvm.internal.DefaultConstructorMarker;
import flavor.pie.itemchat.runtime.kotlin.jvm.internal.Intrinsics;
import flavor.pie.itemchat.runtime.kotlin.jvm.internal.PropertyReference0Impl;
import flavor.pie.itemchat.runtime.kotlin.jvm.internal.Reflection;
import flavor.pie.itemchat.runtime.kotlin.reflect.KProperty;
import flavor.pie.itemchat.runtime.kotlin.sequences.SequencesKt;
import flavor.pie.itemchat.runtime.kotlin.text.MatchGroup;
import flavor.pie.itemchat.runtime.kotlin.text.MatchResult;
import flavor.pie.itemchat.runtime.kotlin.text.Regex;
import flavor.pie.itemchat.runtime.kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import flavor.pie.itemchat.util.kludge.InventoriesKt;
import flavor.pie.itemchat.util.kludge.OptionalsKt;
import flavor.pie.itemchat.util.kludge.TextsKt;
import flavor.pie.itemchat.util.kludge.UncheckedService;
import java.io.BufferedReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.bstats.sponge.MetricsLite2;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataTranslators;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.inventory.type.OrderedInventory;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.service.ServiceManager;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.Tristate;

@Plugin(id="itemchat", name="ItemChat", version="1.4.2", authors={"pie_flavor"}, description="Allows you to display your item in chat.")
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u0003789B)\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0007J\u001a\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020&2\b\b\u0001\u0010#\u001a\u00020$H\u0007J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012J\u0010\u0010*\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020\u0010J\u0010\u0010,\u001a\u00020 2\u0006\u0010!\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020 2\u0006\u0010!\u001a\u00020/H\u0007J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010)\u001a\u00020\u00122\b\b\u0002\u00102\u001a\u000203J\u001c\u00104\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u000203J\n\u00106\u001a\u00020\u0013*\u00020\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR/\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0002`\u00140\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\r\u00a8\u0006:\u00b2\u0006\r\u0010;\u001a\u00020<X\u008a\u0084\u0002\u00a2\u0006\u0000"}, d2={"Lflavor/pie/itemchat/ItemChat;", "", "path", "Ljava/nio/file/Path;", "loader", "Lninja/leaping/configurate/loader/ConfigurationLoader;", "Lninja/leaping/configurate/commented/CommentedConfigurationNode;", "metrics", "Lorg/bstats/sponge/MetricsLite2;", "(Ljava/nio/file/Path;Lninja/leaping/configurate/loader/ConfigurationLoader;Lorg/bstats/sponge/MetricsLite2;)V", "escaped", "Lflavor/pie/itemchat/runtime/kotlin/text/Regex;", "getEscaped", "()Lkotlin/text/Regex;", "expanders", "", "", "Lflavor/pie/itemchat/runtime/kotlin/Function1;", "Lorg/spongepowered/api/item/inventory/ItemStack;", "Lorg/spongepowered/api/text/Text;", "Lflavor/pie/itemchat/Expander;", "getExpanders", "()Ljava/util/Map;", "getLoader", "()Lninja/leaping/configurate/loader/ConfigurationLoader;", "getMetrics", "()Lorg/bstats/sponge/MetricsLite2;", "getPath", "()Ljava/nio/file/Path;", "regex", "getRegex", "chat", "", "e", "Lorg/spongepowered/api/event/message/MessageChannelEvent$Chat;", "p", "Lorg/spongepowered/api/entity/living/player/Player;", "command", "Lorg/spongepowered/api/event/command/SendCommandEvent;", "getData", "", "stack", "parseItem", "str", "postInit", "Lorg/spongepowered/api/event/game/state/GamePostInitializationEvent;", "preInit", "Lorg/spongepowered/api/event/game/state/GamePreInitializationEvent;", "toNBT", "Lorg/spongepowered/api/data/DataContainer;", "tagKey", "", "addItem", "isChat", "unescape", "Companion", "Permissions", "Queries", "ItemChat", "svc", "Lorg/spongepowered/api/service/permission/PermissionService;"})
public final class ItemChat {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Map<String, Function1<ItemStack, Text>> expanders;
    @NotNull
    private final Regex regex;
    @NotNull
    private final Regex escaped;
    @NotNull
    private final Path path;
    @NotNull
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    @NotNull
    private final MetricsLite2 metrics;
    @Language(value="RegExp")
    @NotNull
    public static final String pattern = "\\{item(@(?<expander>[^ ]+))?( \\$(?<slot>[1-9]))?(?<book> #!(?<bookslot>[1-9])?)?( (?<name>[^({].+?))?( (\\((?<nbtp>\\{.*?})\\)|(?<nbt>\\{.*}(?!\\)))))?}";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property0(new PropertyReference0Impl(Reflection.getOrCreateKotlinClass(ItemChat.class), "svc", "<v#0>"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Map<String, Function1<ItemStack, Text>> getExpanders() {
        return this.expanders;
    }

    @Listener
    public final void preInit(@NotNull GamePreInitializationEvent e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        if (!Files.exists(this.path, new LinkOption[0])) {
            AssetManager assetManager = Sponge.getAssetManager();
            Intrinsics.checkExpressionValueIsNotNull(assetManager, "Sponge.getAssetManager()");
            ((Asset)assetManager.getAsset((Object)this, "default.conf").get()).copyToFile(this.path);
        }
        Object object = ((CommentedConfigurationNode)this.loader.load()).getValue(Config.Companion.getType());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        ItemChatKt.setConfig((Config)object);
    }

    @Listener
    public final void postInit(@NotNull GamePostInitializationEvent e) {
        UncheckedService.Companion svc;
        Intrinsics.checkParameterIsNotNull(e, "e");
        KProperty kProperty = $$delegatedProperties[0];
        UncheckedService.Companion companion = svc = UncheckedService.Companion;
        Object thisRef$iv = null;
        ServiceManager serviceManager = Sponge.getServiceManager();
        Intrinsics.checkExpressionValueIsNotNull(serviceManager, "Sponge.getServiceManager()");
        Object object = serviceManager.provideUnchecked(PermissionService.class);
        Intrinsics.checkExpressionValueIsNotNull(object, "ServiceManager.provideUnchecked(T::class.java)");
        Subject subject = ((PermissionService)object).getDefaults();
        Intrinsics.checkExpressionValueIsNotNull(subject, "svc.defaults");
        subject.getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "itemchat.arbitrary_nbt", Tristate.TRUE);
    }

    @Listener
    public final void chat(@NotNull MessageChannelEvent.Chat e, @First @NotNull Player p) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        Intrinsics.checkParameterIsNotNull(p, "p");
        MessageEvent.MessageFormatter messageFormatter = e.getFormatter();
        Intrinsics.checkExpressionValueIsNotNull(messageFormatter, "e.formatter");
        Text msg = messageFormatter.getBody().format();
        String string = msg.toPlain();
        Intrinsics.checkExpressionValueIsNotNull(string, "msg.toPlain()");
        int size = SequencesKt.toList(Regex.findAll$default(this.regex, string, 0, 2, null)).size();
        if (size > 1) {
            p.sendMessage((Text)TextsKt.not("You cannot use {item} more than once!"));
        } else if (size == 1) {
            MessageEvent.MessageFormatter messageFormatter2 = e.getFormatter();
            Text text2 = msg;
            Intrinsics.checkExpressionValueIsNotNull(text2, "msg");
            Text text3 = this.addItem(text2, p, true);
            if (text3 == null || (text3 = this.unescape(text3)) == null) {
                return;
            }
            messageFormatter2.setBody((TextRepresentable)text3);
        } else {
            Text text4 = msg;
            Intrinsics.checkExpressionValueIsNotNull(text4, "msg");
            Text unescaped = this.unescape(text4);
            if (Intrinsics.areEqual(unescaped, msg) ^ true) {
                e.getFormatter().setBody((TextRepresentable)unescaped);
            }
        }
    }

    @Listener
    public final void command(@NotNull SendCommandEvent e, @First @NotNull Player p) {
        Text withItem;
        Intrinsics.checkParameterIsNotNull(e, "e");
        Intrinsics.checkParameterIsNotNull(p, "p");
        String string = e.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(string, "e.arguments");
        Text args = (Text)TextsKt.text(string);
        String string2 = e.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(string2, "e.arguments");
        int size = SequencesKt.toList(Regex.findAll$default(this.regex, string2, 0, 2, null)).size();
        if (size > 1) {
            p.sendMessage((Text)TextsKt.not("You cannot use {item} more than once!"));
        } else if (size == 1 && (withItem = this.addItem(args, p, false)) != null) {
            args = withItem;
        }
        e.setArguments(this.unescape(args).toPlain());
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @NotNull
    public final Regex getEscaped() {
        return this.escaped;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Text addItem(@NotNull Text $receiver, @NotNull Player p, boolean isChat) {
        Object object;
        Object object2;
        LiteralText literalText;
        LiteralText literalText2;
        LiteralText literalText3;
        LiteralText literalText4;
        void part1;
        LiteralText literalText5;
        Text text2;
        ItemStack itemStack;
        String plain;
        Text text3;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(p, "p");
        if ($receiver.getChildren().isEmpty()) {
            text3 = $receiver;
        } else {
            Collection<Text> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Text.Builder builder = $receiver.toBuilder().removeAll();
            ImmutableList immutableList = $receiver.getChildren();
            Intrinsics.checkExpressionValueIsNotNull(immutableList, "children");
            Iterable iterable = (Iterable)immutableList;
            Text.Builder builder2 = builder;
            void var6_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Text text4 = (Text)item$iv$iv;
                collection = destination$iv$iv;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                Text text5 = this.addItem((Text)v3, p, isChat);
                if (text5 == null) {
                    text5 = it;
                }
                Text text6 = text5;
                collection.add(text6);
            }
            collection = (List)destination$iv$iv;
            text3 = builder2.append((Collection)collection).build();
        }
        Text msg = text3;
        String string = plain = $receiver.toPlainSingle();
        Intrinsics.checkExpressionValueIsNotNull(string, "plain");
        MatchResult matchResult = Regex.find$default(this.regex, string, 0, 2, null);
        if (matchResult == null) {
            return msg;
        }
        MatchResult res = matchResult;
        MatchGroup name = RegexExtensionsJDK8Kt.get(res.getGroups(), "name");
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(res.getGroups(), "nbt");
        if (matchGroup == null) {
            matchGroup = RegexExtensionsJDK8Kt.get(res.getGroups(), "nbtp");
        }
        MatchGroup nbt = matchGroup;
        MatchGroup slot = RegexExtensionsJDK8Kt.get(res.getGroups(), "slot");
        MatchGroup book = RegexExtensionsJDK8Kt.get(res.getGroups(), "book");
        MatchGroup bookslot = RegexExtensionsJDK8Kt.get(res.getGroups(), "bookslot");
        MatchGroup expander = RegexExtensionsJDK8Kt.get(res.getGroups(), "expander");
        TextColor color1 = TextColors.YELLOW;
        TextColor color2 = TextColors.GOLD;
        TextColor color3 = TextColors.AQUA;
        if (nbt == null) {
            if (slot == null) {
                if (book == null) {
                    ItemStack itemStack2 = (ItemStack)OptionalsKt.unwrap(p.getItemInHand(HandTypes.MAIN_HAND));
                    if (itemStack2 == null) {
                        itemStack2 = itemStack = (ItemStack)OptionalsKt.unwrap(p.getItemInHand(HandTypes.OFF_HAND));
                    }
                    if (itemStack2 == null) {
                        return null;
                    }
                } else {
                    if (!p.hasPermission("itemchat.arbitrary_nbt")) {
                        p.sendMessage((Text)TextsKt.not("You don't have permission to create NBT item text!"));
                        return null;
                    }
                    if (bookslot == null) {
                        ItemStack itemStack3 = (ItemStack)OptionalsKt.unwrap(p.getItemInHand(HandTypes.MAIN_HAND));
                        if (itemStack3 == null) {
                            itemStack3 = (ItemStack)OptionalsKt.unwrap(p.getItemInHand(HandTypes.OFF_HAND));
                        }
                        if (itemStack3 == null) {
                            return null;
                        }
                        ItemStack bookStack = itemStack3;
                        Object object3 = (List)OptionalsKt.unwrap(bookStack.get(Keys.BOOK_PAGES));
                        if (object3 == null || (object3 = CollectionsKt.joinToString$default((Iterable)object3, "", null, null, 0, null, addItem.i.text.1.INSTANCE, 30, null)) == null) {
                            return null;
                        }
                        Object text222 = object3;
                        itemStack = this.parseItem((String)text222);
                        if (itemStack == null) {
                            Text text7;
                            Text $receiver2 = text7 = $receiver;
                            p.sendMessage((Text)TextsKt.not("Invalid NBT!"));
                            return null;
                        }
                    } else {
                        int num;
                        int text222;
                        color1 = TextColors.LIGHT_PURPLE;
                        color2 = TextColors.DARK_PURPLE;
                        color3 = TextColors.DARK_AQUA;
                        try {
                            String text222 = bookslot.getValue();
                            text222 = Integer.parseInt(text222);
                        }
                        catch (NumberFormatException ex) {
                            p.sendMessage((Text)TextsKt.not("Invalid index!"));
                            return null;
                        }
                        text222 = num = text222;
                        if (1 > text222 || 9 < text222) {
                            p.sendMessage((Text)TextsKt.not("Invalid index!"));
                            return null;
                        }
                        CarriedInventory carriedInventory = p.getInventory();
                        Intrinsics.checkExpressionValueIsNotNull(carriedInventory, "p.inventory");
                        Slot slot2 = InventoriesKt.get((OrderedInventory)InventoriesKt.get((Inventory)carriedInventory, Reflection.getOrCreateKotlinClass(Hotbar.class)), num - 1);
                        if (slot2 == null) {
                            Intrinsics.throwNpe();
                        }
                        ItemStack itemStack4 = (ItemStack)OptionalsKt.unwrap(slot2.peek());
                        if (itemStack4 == null) {
                            return null;
                        }
                        ItemStack bookStack22 = itemStack4;
                        Object object4 = (List)OptionalsKt.unwrap(bookStack22.get(Keys.BOOK_PAGES));
                        if (object4 == null || (object4 = CollectionsKt.joinToString$default((Iterable)object4, "", null, null, 0, null, addItem.i.text.2.INSTANCE, 30, null)) == null) {
                            return null;
                        }
                        Object text8 = object4;
                        itemStack = this.parseItem((String)text8);
                        if (itemStack == null) {
                            Text $receiver2;
                            Text $receiver3 = $receiver2 = $receiver;
                            p.sendMessage((Text)TextsKt.not("Invalid NBT!"));
                            return null;
                        }
                    }
                }
            } else {
                int num;
                int bookStack22;
                try {
                    String bookStack22 = slot.getValue();
                    bookStack22 = Integer.parseInt(bookStack22);
                }
                catch (NumberFormatException ex) {
                    p.sendMessage((Text)TextsKt.not("Invalid index!"));
                    return null;
                }
                bookStack22 = num = bookStack22;
                if (1 > bookStack22 || 9 < bookStack22) {
                    p.sendMessage((Text)TextsKt.not("Invalid index!"));
                    return null;
                }
                CarriedInventory carriedInventory = p.getInventory();
                Intrinsics.checkExpressionValueIsNotNull(carriedInventory, "p.inventory");
                Slot slot3 = InventoriesKt.get((OrderedInventory)InventoriesKt.get((Inventory)carriedInventory, Reflection.getOrCreateKotlinClass(Hotbar.class)), num - 1);
                if (slot3 == null) {
                    Intrinsics.throwNpe();
                }
                if ((itemStack = (ItemStack)OptionalsKt.unwrap(slot3.peek())) == null) {
                    return null;
                }
            }
        } else {
            if (!p.hasPermission("itemchat.arbitrary_nbt")) {
                p.sendMessage((Text)TextsKt.not("You don't have permission to create NBT item text!"));
                return null;
            }
            color1 = TextColors.LIGHT_PURPLE;
            color2 = TextColors.DARK_PURPLE;
            color3 = TextColors.DARK_AQUA;
            itemStack = this.parseItem(nbt.getValue());
            if (itemStack == null) {
                Text num;
                Text $receiver4 = num = $receiver;
                p.sendMessage((Text)TextsKt.not("Invalid NBT!"));
                return null;
            }
        }
        ItemStack i2 = itemStack;
        if (expander == null) {
            Text text9;
            if (name == null) {
                Text dispName = (Text)OptionalsKt.unwrap(i2.get(Keys.DISPLAY_NAME));
                if (dispName == null) {
                    Text text10 = TextsKt.plus(TextsKt.plus((Text)TextsKt.not("["), (Translatable)i2), "]");
                    TextColor textColor = color1;
                    Intrinsics.checkExpressionValueIsNotNull(textColor, "color1");
                    text9 = TextsKt.color(text10, textColor);
                } else {
                    Text text11 = TextsKt.plus(TextsKt.plus((Text)TextsKt.not("["), dispName), "]");
                    TextColor textColor = color2;
                    Intrinsics.checkExpressionValueIsNotNull(textColor, "color2");
                    text9 = TextsKt.color(text11, textColor);
                }
            } else {
                String string2 = '[' + name.getValue() + ']';
                TextColor textColor = color3;
                Intrinsics.checkExpressionValueIsNotNull(textColor, "color3");
                text9 = (Text)TextsKt.color(string2, textColor);
            }
            HoverAction.ShowItem showItem = TextActions.showItem((ItemStackSnapshot)i2.createSnapshot());
            Intrinsics.checkExpressionValueIsNotNull(showItem, "TextActions.showItem(i.createSnapshot())");
            text2 = TextsKt.onHover(text9, (HoverAction)showItem);
        } else {
            Text $i$a$3$run = this.expanders;
            String $receiver2 = expander.getValue();
            Object $receiver3 = null;
            Text text12 = $i$a$3$run;
            if (text12 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            Function1 ext = text12.getOrDefault($receiver2, $receiver3);
            if (ext == null) {
                p.sendMessage((Text)TextsKt.not("Invalid expander " + expander.getValue() + '!'));
                return null;
            }
            Text text13 = (Text)ext.invoke(i2);
            if (text13 == null) {
                return null;
            }
            Text it = $i$a$3$run = text13;
            if (isChat && !p.hasPermission("itemchat.bypass_expander_size") && it.toPlain().length() > ItemChatKt.getConfig().getMaxExpanderSizeChat()) {
                p.sendMessage((Text)TextsKt.not("Expanded item too long!"));
                return null;
            }
            text2 = $i$a$3$run;
        }
        Text itemText = text2;
        Text text14 = msg;
        Intrinsics.checkExpressionValueIsNotNull(text14, "msg");
        TextStyle style = text14.getStyle();
        Optional hover = msg.getHoverAction();
        Optional click = msg.getClickAction();
        Optional shift = msg.getShiftClickAction();
        LiteralText literalText6 = plain;
        Regex regex = this.regex;
        int n = 0;
        literalText6 = literalText5 = regex.split((CharSequence)literalText6, n);
        String $i$a$2$run = (String)literalText6.get(0);
        literalText6 = literalText5;
        String part2 = literalText6.get(1);
        Object it = literalText6 = part1;
        Optional optional = hover;
        Intrinsics.checkExpressionValueIsNotNull(optional, "hover");
        if (optional.isPresent()) {
            Object t = hover.get();
            Intrinsics.checkExpressionValueIsNotNull(t, "hover.get()");
            literalText4 = TextsKt.onHover((String)it, (HoverAction)t);
        } else {
            literalText4 = TextsKt.not(it);
        }
        it = literalText6 = literalText4;
        Optional optional2 = click;
        Intrinsics.checkExpressionValueIsNotNull(optional2, "click");
        if (optional2.isPresent()) {
            Object t = click.get();
            Intrinsics.checkExpressionValueIsNotNull(t, "click.get()");
            literalText3 = TextsKt.onClick(it, (ClickAction)t);
        } else {
            literalText3 = it;
        }
        it = literalText6 = literalText3;
        Optional optional3 = shift;
        Intrinsics.checkExpressionValueIsNotNull(optional3, "shift");
        if (optional3.isPresent()) {
            Object t = shift.get();
            Intrinsics.checkExpressionValueIsNotNull(t, "shift.get()");
            literalText2 = TextsKt.onShiftClick(it, (ShiftClickAction)t);
        } else {
            literalText2 = it;
        }
        LiteralText fmtPart1 = literalText2;
        Object it2 = it = part2;
        if (hover.isPresent()) {
            Object t = hover.get();
            Intrinsics.checkExpressionValueIsNotNull(t, "hover.get()");
            literalText = TextsKt.onHover((String)it2, (HoverAction)t);
        } else {
            literalText = TextsKt.not((String)it2);
        }
        it2 = it = literalText;
        if (click.isPresent()) {
            Object t = click.get();
            Intrinsics.checkExpressionValueIsNotNull(t, "click.get()");
            object2 = TextsKt.onClick(it2, (ClickAction)t);
        } else {
            object2 = it2;
        }
        it2 = it = object2;
        if (shift.isPresent()) {
            Object t = shift.get();
            Intrinsics.checkExpressionValueIsNotNull(t, "shift.get()");
            object = TextsKt.onShiftClick(it2, (ShiftClickAction)t);
        } else {
            object = it2;
        }
        Object fmtPart2 = object;
        Text.Builder builder = Text.builder();
        Intrinsics.checkExpressionValueIsNotNull(builder, "Text.builder()");
        Text.Builder builder3 = TextsKt.plus(TextsKt.plus(TextsKt.plus(builder, (Text)fmtPart1), itemText), (Text)fmtPart2);
        return builder3.style(new TextStyle[]{style}).build();
    }

    @NotNull
    public final Text unescape(@NotNull Text $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Text text2 = $receiver;
        String string = $receiver.toPlain();
        Intrinsics.checkExpressionValueIsNotNull(string, "toPlain()");
        Iterator iterator2 = Regex.findAll$default(this.escaped, string, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            String string2;
            MatchResult res = (MatchResult)iterator2.next();
            String string3 = res.getValue();
            int n = 1;
            String string4 = res.getValue();
            Text text3 = text2;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull(string5.substring(n), "(this as java.lang.String).substring(startIndex)");
            text2 = TextsKt.replace$default(text3, string4, (Text)TextsKt.not(string2), false, false, 12, null);
        }
        return text2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final ItemStack parseItem(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull(str, "str");
        try {
            CommentedConfigurationNode node2 = (CommentedConfigurationNode)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource((Callable)new Callable<BufferedReader>(str){
                final /* synthetic */ String $str;

                @NotNull
                public final BufferedReader call() {
                    return new BufferedReader(new StringReader(this.$str));
                }
                {
                    this.$str = string;
                }
            })).build().load();
            DataContainer data = DataTranslators.CONFIGURATION_NODE.translate((Object)node2);
            DataContainer sData = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
            sData.set(Queries.INSTANCE.getContentVersion(), (Object)1);
            for (DataQuery key : data.getKeys(false)) {
                DataQuery dataQuery = key;
                if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getDamage())) {
                    sData.set(Queries.INSTANCE.getUnsafeDamage(), data.getInt(key).get());
                    continue;
                }
                if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getCount())) {
                    sData.set(Queries.INSTANCE.getCount(), data.getInt(key).get());
                    continue;
                }
                if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getId())) {
                    sData.set(Queries.INSTANCE.getItemType(), data.getString(key).get());
                    continue;
                }
                if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getTag())) {
                    for (DataQuery tag : ((DataView)data.getView(key).get()).getKeys(false)) {
                        sData.set(Queries.INSTANCE.getUnsafeData().then(tag), data.get(key.then(tag)).get());
                    }
                    continue;
                }
                sData.set(Queries.INSTANCE.getUnsafeData().then(key), data.get(key).get());
            }
            DataQuery dataQuery = Queries.INSTANCE.getUnsafeDamage();
            DataQuery it = dataQuery;
            if (!sData.contains(it)) {
                sData.set(it, (Object)0);
            }
            it = dataQuery = Queries.INSTANCE.getUnsafeData();
            if (!sData.contains(it)) {
                sData.createView(it);
            }
            it = dataQuery = Queries.INSTANCE.getItemType();
            if (!sData.contains(it)) {
                ItemType itemType = ItemTypes.STONE;
                Intrinsics.checkExpressionValueIsNotNull(itemType, "ItemTypes.STONE");
                sData.set(it, (Object)itemType.getId());
            }
            it = dataQuery = Queries.INSTANCE.getCount();
            if (!sData.contains(it)) {
                sData.set(it, (Object)1);
            }
            ItemStackSnapshot itemStackSnapshot = (ItemStackSnapshot)OptionalsKt.unwrap(sData.getSerializable(DataQuery.of(), ItemStackSnapshot.class));
            if (itemStackSnapshot == null) return null;
            ItemStack itemStack = itemStackSnapshot.createStack();
            return itemStack;
        }
        catch (Exception _) {
            return null;
        }
    }

    @Nullable
    public final DataContainer toNBT(@NotNull ItemStack stack, boolean tagKey) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        try {
            DataContainer data = stack.toContainer();
            DataContainer sData = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
            for (DataQuery key : data.getKeys(false)) {
                DataQuery dataQuery = key;
                if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getUnsafeDamage())) {
                    sData.set(Queries.INSTANCE.getDamage(), data.getInt(key).get());
                } else if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getCount())) {
                    sData.set(Queries.INSTANCE.getCount(), data.getInt(key).get());
                } else if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getItemType())) {
                    sData.set(Queries.INSTANCE.getId(), data.getString(key).get());
                } else if (Intrinsics.areEqual(dataQuery, Queries.INSTANCE.getUnsafeData())) {
                    for (DataQuery tag : ((DataView)data.getView(key).get()).getKeys(false)) {
                        sData.set(tagKey ? Queries.INSTANCE.getTag().then(tag) : tag, data.get(key.then(tag)).get());
                    }
                }
                DataQuery it = dataQuery = Queries.INSTANCE.getId();
                if (!sData.contains(it)) {
                    ItemType itemType = ItemTypes.STONE;
                    Intrinsics.checkExpressionValueIsNotNull(itemType, "ItemTypes.STONE");
                    sData.set(it, (Object)itemType.getId());
                }
                it = dataQuery = Queries.INSTANCE.getDamage();
                if (!sData.contains(it)) {
                    sData.set(it, (Object)0);
                }
                it = dataQuery = Queries.INSTANCE.getCount();
                if (!sData.contains(it)) {
                    sData.set(it, (Object)1);
                }
                if (!tagKey || sData.contains(it = (dataQuery = Queries.INSTANCE.getTag()))) continue;
                sData.createView(it);
            }
            return sData;
        }
        catch (Exception _) {
            return null;
        }
    }

    @Nullable
    public static /* bridge */ /* synthetic */ DataContainer toNBT$default(ItemChat itemChat, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return itemChat.toNBT(itemStack, bl);
    }

    public final int getData(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Integer n = stack.toContainer().getInt(Queries.INSTANCE.getUnsafeDamage()).orElse(0);
        Intrinsics.checkExpressionValueIsNotNull(n, "stack.toContainer().getI\u2026s.unsafeDamage).orElse(0)");
        return ((Number)n).intValue();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final ConfigurationLoader<CommentedConfigurationNode> getLoader() {
        return this.loader;
    }

    @NotNull
    public final MetricsLite2 getMetrics() {
        return this.metrics;
    }

    @Inject
    public ItemChat(@DefaultConfig(sharedRoot=true) @NotNull Path path, @DefaultConfig(sharedRoot=true) @NotNull ConfigurationLoader<CommentedConfigurationNode> loader, @NotNull MetricsLite2 metrics) {
        Regex regex;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(loader, "loader");
        Intrinsics.checkParameterIsNotNull(metrics, "metrics");
        this.path = path;
        this.loader = loader;
        this.metrics = metrics;
        this.expanders = MapsKt.mutableMapOf(TuplesKt.to("nbt", new Function1<ItemStack, LiteralText>(this){
            final /* synthetic */ ItemChat this$0;

            @Nullable
            public final LiteralText invoke(@NotNull ItemStack item) {
                LiteralText literalText;
                Intrinsics.checkParameterIsNotNull(item, "item");
                DataContainer dataContainer = ItemChat.toNBT$default(this.this$0, item, false, 2, null);
                if (dataContainer != null) {
                    DataContainer dataContainer2;
                    DataContainer it = dataContainer2 = dataContainer;
                    String string = DataFormats.JSON.write((DataView)it);
                    Intrinsics.checkExpressionValueIsNotNull(string, "DataFormats.JSON.write(it)");
                    literalText = TextsKt.text(string);
                } else {
                    literalText = null;
                }
                return literalText;
            }
            {
                this.this$0 = itemChat;
                super(1);
            }
        }), TuplesKt.to("nbt+tag", new Function1<ItemStack, LiteralText>(this){
            final /* synthetic */ ItemChat this$0;

            @Nullable
            public final LiteralText invoke(@NotNull ItemStack item) {
                LiteralText literalText;
                Intrinsics.checkParameterIsNotNull(item, "item");
                DataContainer dataContainer = this.this$0.toNBT(item, true);
                if (dataContainer != null) {
                    DataContainer dataContainer2;
                    DataContainer it = dataContainer2 = dataContainer;
                    String string = DataFormats.JSON.write((DataView)it);
                    Intrinsics.checkExpressionValueIsNotNull(string, "DataFormats.JSON.write(it)");
                    literalText = TextsKt.text(string);
                } else {
                    literalText = null;
                }
                return literalText;
            }
            {
                this.this$0 = itemChat;
                super(1);
            }
        }), TuplesKt.to("/give", new Function1<ItemStack, LiteralText>(this){
            final /* synthetic */ ItemChat this$0;

            @Nullable
            public final LiteralText invoke(@NotNull ItemStack item) {
                Object object;
                StringBuilder stringBuilder;
                block3: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull(item, "item");
                        StringBuilder stringBuilder2 = new StringBuilder();
                        ItemType itemType = item.getType();
                        Intrinsics.checkExpressionValueIsNotNull(itemType, "item.type");
                        stringBuilder = stringBuilder2.append(itemType.getId()).append(' ').append(item.getQuantity()).append(' ').append(this.this$0.getData(item)).append(' ');
                        object = ItemChat.toNBT$default(this.this$0, item, false, 2, null);
                        if (object == null) break block2;
                        DataContainer dataContainer = object;
                        StringBuilder stringBuilder3 = stringBuilder;
                        DataContainer it = dataContainer;
                        String string = DataFormats.JSON.write((DataView)it);
                        stringBuilder = stringBuilder3;
                        object = string;
                        if (object != null) break block3;
                    }
                    return null;
                }
                return TextsKt.text(stringBuilder.append((String)object).toString());
            }
            {
                this.this$0 = itemChat;
                super(1);
            }
        }), TuplesKt.to("/summon", new Function1<ItemStack, LiteralText>(this){
            final /* synthetic */ ItemChat this$0;

            @Nullable
            public final LiteralText invoke(@NotNull ItemStack item) {
                Object object;
                StringBuilder stringBuilder;
                block3: {
                    block2: {
                        Intrinsics.checkParameterIsNotNull(item, "item");
                        stringBuilder = new StringBuilder().append("{Age:-32768,Health:5,Item:");
                        object = this.this$0.toNBT(item, true);
                        if (object == null) break block2;
                        DataContainer dataContainer = object;
                        StringBuilder stringBuilder2 = stringBuilder;
                        DataContainer it = dataContainer;
                        String string = DataFormats.JSON.write((DataView)it);
                        stringBuilder = stringBuilder2;
                        object = string;
                        if (object != null) break block3;
                    }
                    return null;
                }
                return TextsKt.text(stringBuilder.append((String)object).append('}').toString());
            }
            {
                this.this$0 = itemChat;
                super(1);
            }
        }), TuplesKt.to("name", expanders.5.INSTANCE), TuplesKt.to("id", expanders.6.INSTANCE), TuplesKt.to("type", expanders.7.INSTANCE), TuplesKt.to("count", expanders.8.INSTANCE), TuplesKt.to("data", new Function1<ItemStack, LiteralText>(this){
            final /* synthetic */ ItemChat this$0;

            @NotNull
            public final LiteralText invoke(@NotNull ItemStack item) {
                Intrinsics.checkParameterIsNotNull(item, "item");
                return TextsKt.text(String.valueOf(this.this$0.getData(item)));
            }
            {
                this.this$0 = itemChat;
                super(1);
            }
        }));
        String string = "(?<!\\$)\\{item(@(?<expander>[^ ]+))?( \\$(?<slot>[1-9]))?(?<book> #!(?<bookslot>[1-9])?)?( (?<name>[^({].+?))?( (\\((?<nbtp>\\{.*?})\\)|(?<nbt>\\{.*}(?!\\)))))?}";
        ItemChat itemChat = this;
        itemChat.regex = regex = new Regex(string);
        string = "\\$+\\{item(@(?<expander>[^ ]+))?( \\$(?<slot>[1-9]))?(?<book> #!(?<bookslot>[1-9])?)?( (?<name>[^({].+?))?( (\\((?<nbtp>\\{.*?})\\)|(?<nbt>\\{.*}(?!\\)))))?}";
        itemChat = this;
        itemChat.escaped = regex = new Regex(string);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lflavor/pie/itemchat/ItemChat$Queries;", "", "()V", "contentVersion", "Lorg/spongepowered/api/data/DataQuery;", "getContentVersion", "()Lorg/spongepowered/api/data/DataQuery;", "count", "getCount", "damage", "getDamage", "id", "getId", "itemType", "getItemType", "tag", "getTag", "unsafeDamage", "getUnsafeDamage", "unsafeData", "getUnsafeData", "ItemChat"})
    public static final class Queries {
        @NotNull
        private static final DataQuery unsafeDamage;
        @NotNull
        private static final DataQuery count;
        @NotNull
        private static final DataQuery contentVersion;
        @NotNull
        private static final DataQuery unsafeData;
        @NotNull
        private static final DataQuery itemType;
        @NotNull
        private static final DataQuery damage;
        @NotNull
        private static final DataQuery id;
        @NotNull
        private static final DataQuery tag;
        public static final Queries INSTANCE;

        @NotNull
        public final DataQuery getUnsafeDamage() {
            return unsafeDamage;
        }

        @NotNull
        public final DataQuery getCount() {
            return count;
        }

        @NotNull
        public final DataQuery getContentVersion() {
            return contentVersion;
        }

        @NotNull
        public final DataQuery getUnsafeData() {
            return unsafeData;
        }

        @NotNull
        public final DataQuery getItemType() {
            return itemType;
        }

        @NotNull
        public final DataQuery getDamage() {
            return damage;
        }

        @NotNull
        public final DataQuery getId() {
            return id;
        }

        @NotNull
        public final DataQuery getTag() {
            return tag;
        }

        private Queries() {
        }

        static {
            Queries queries;
            INSTANCE = queries = new Queries();
            DataQuery dataQuery = DataQuery.of((String[])new String[]{"UnsafeDamage"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery, "DataQuery.of(\"UnsafeDamage\")");
            unsafeDamage = dataQuery;
            DataQuery dataQuery2 = DataQuery.of((String[])new String[]{"Count"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery2, "DataQuery.of(\"Count\")");
            count = dataQuery2;
            DataQuery dataQuery3 = DataQuery.of((String[])new String[]{"ContentVersion"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery3, "DataQuery.of(\"ContentVersion\")");
            contentVersion = dataQuery3;
            DataQuery dataQuery4 = DataQuery.of((String[])new String[]{"UnsafeData"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery4, "DataQuery.of(\"UnsafeData\")");
            unsafeData = dataQuery4;
            DataQuery dataQuery5 = DataQuery.of((String[])new String[]{"ItemType"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery5, "DataQuery.of(\"ItemType\")");
            itemType = dataQuery5;
            DataQuery dataQuery6 = DataQuery.of((String[])new String[]{"Damage"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery6, "DataQuery.of(\"Damage\")");
            damage = dataQuery6;
            DataQuery dataQuery7 = DataQuery.of((String[])new String[]{"id"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery7, "DataQuery.of(\"id\")");
            id = dataQuery7;
            DataQuery dataQuery8 = DataQuery.of((String[])new String[]{"tag"});
            Intrinsics.checkExpressionValueIsNotNull(dataQuery8, "DataQuery.of(\"tag\")");
            tag = dataQuery8;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lflavor/pie/itemchat/ItemChat$Permissions;", "", "()V", "arbitraryNbt", "", "bypassExpanderSize", "ItemChat"})
    public static final class Permissions {
        @NotNull
        public static final String arbitraryNbt = "itemchat.arbitrary_nbt";
        @NotNull
        public static final String bypassExpanderSize = "itemchat.bypass_expander_size";
        public static final Permissions INSTANCE;

        private Permissions() {
        }

        static {
            Permissions permissions;
            INSTANCE = permissions = new Permissions();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lflavor/pie/itemchat/ItemChat$Companion;", "", "()V", "pattern", "", "ItemChat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

