/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.mtrm.network;

import io.netty.buffer.ByteBuf;
import net.doubledoordev.mtrm.MineTweakerRecipeMaker;
import net.doubledoordev.mtrm.gui.MTRMGui;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageResponse
implements IMessage {
    private Status status;
    private String message;

    public MessageResponse() {
    }

    public MessageResponse(Status status, Object ... args) {
        this.status = status;
        this.message = status.message == null ? null : String.format(status.message, args);
    }

    public void fromBytes(ByteBuf buf) {
        this.status = Status.values()[buf.readByte()];
        if (this.status.message != null) {
            this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.status.ordinal());
        if (this.message != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        }
    }

    public static enum Status {
        OK(null),
        NO_OUT("There is no output specified."),
        NO_IN("There is no input specified."),
        WRITE_ERROR("IOError: %s");

        private final String message;

        private Status(String message) {
            this.message = message;
        }
    }

    public static class Handler
    implements IMessageHandler<MessageResponse, IMessage> {
        public IMessage onMessage(MessageResponse message, MessageContext ctx) {
            if (message.status == Status.OK) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a(new TextComponentString("Saved recipe change.").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            } else {
                Minecraft.func_71410_x().field_71439_g.func_145747_a(new TextComponentString(message.message).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                MineTweakerRecipeMaker.getLogger().info("Something went wrong: {}. Message: {}", (Object)message.status.name(), (Object)message.message);
                if (Minecraft.func_71410_x().field_71462_r instanceof MTRMGui) {
                    ((MTRMGui)Minecraft.func_71410_x().field_71462_r).showMessage(message.message);
                }
            }
            return null;
        }
    }
}

