/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.fluidcell;

import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.TRSRTransformation;
import trinsdar.ic2c_extras.util.fluidcell.BakedQuadTinted;

public class ModelUtils {
    private static Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER;
    private static EnumMap<ItemCameraTransforms.TransformType, Matrix4f> TRANSFORM_MAP_ITEM;

    public static Function<ResourceLocation, TextureAtlasSprite> getTextureGetter() {
        if (TEXTURE_GETTER == null) {
            TEXTURE_GETTER = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
        return TEXTURE_GETTER;
    }

    public static Matrix4f getItemTransform(ItemCameraTransforms.TransformType type) {
        Matrix4f mat = TRANSFORM_MAP_ITEM.get(type);
        return mat != null ? mat : TRSRTransformation.identity().getMatrix();
    }

    public static TRSRTransformation getTransform(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public static IModel load(String path) {
        return ModelUtils.load(new ModelResourceLocation("ic2c_extras:" + path));
    }

    public static IModel load(String domain, String path) {
        return ModelUtils.load(new ModelResourceLocation(domain + ":" + path));
    }

    public static IModel load(ModelResourceLocation loc) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)loc);
        }
        catch (Exception e) {
            System.err.println("I Fucked up : " + e + ":");
            e.printStackTrace();
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public static List<BakedQuad> texAndTint(List<BakedQuad> quads, int rgb, TextureAtlasSprite sprite) {
        LinkedList<BakedQuad> quadsTemp = new LinkedList<BakedQuad>();
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            BakedQuadRetextured quad = new BakedQuadRetextured(quads.get(i), sprite);
            quadsTemp.add(new BakedQuadTinted((BakedQuad)quad, rgb));
        }
        return quadsTemp;
    }

    public static int rgbToABGR(int rgb) {
        int r = (rgb |= 0xFF000000) >> 16 & 0xFF;
        int b = rgb & 0xFF;
        return rgb & 0xFF00FF00 | b << 16 | r;
    }

    static {
        TRANSFORM_MAP_ITEM = new EnumMap(ItemCameraTransforms.TransformType.class);
        TRANSFORM_MAP_ITEM.put(ItemCameraTransforms.TransformType.GUI, ModelUtils.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).getMatrix());
        TRANSFORM_MAP_ITEM.put(ItemCameraTransforms.TransformType.GROUND, ModelUtils.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f).getMatrix());
        TRANSFORM_MAP_ITEM.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ModelUtils.getTransform(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f).getMatrix());
        TRANSFORM_MAP_ITEM.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ModelUtils.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f).getMatrix());
        TRANSFORM_MAP_ITEM.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ModelUtils.getTransform(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f).getMatrix());
        TRANSFORM_MAP_ITEM.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ModelUtils.getTransform(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f).getMatrix());
    }
}

