/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.recipelists;

import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.machine.recipes.managers.RecipeManager;
import ic2.core.util.helpers.CompareableStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import trinsdar.ic2c_extras.IC2CExtras;

public class ContainerInputRecipeList {
    public static final ContainerInputRecipe INVALID_RECIPE = new ContainerInputRecipe(null, ItemStack.field_190927_a, new MachineOutput(null, new ArrayList()), "Invalid");
    protected List<ContainerInputRecipe> recipes = new ArrayList<ContainerInputRecipe>();
    protected Map<String, ContainerInputRecipe> recipeMap = new LinkedHashMap<String, ContainerInputRecipe>();
    protected Map<CompareableStack, IRecipeInput> validInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    protected Map<String, ItemStack> validContainers = new LinkedHashMap<String, ItemStack>();
    String category;

    public ContainerInputRecipeList(String category) {
        this.category = category;
    }

    public void addRecipe(IRecipeInput input, ItemStack press, MachineOutput output, String id) {
        id = ContainerInputRecipeList.getRecipeID(this.recipeMap.keySet(), id, 0);
        if (this.recipeMap.containsKey(id) || !RecipeManager.register((String)this.category, (String)id)) {
            return;
        }
        if (input == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid input for machine " + this.category);
            return;
        }
        if (press == null || press == ItemStack.field_190927_a) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid press input for machine " + this.category);
            return;
        }
        if (this.isListInvalid(output.getAllOutputs())) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid output for machine " + this.category);
            IC2CExtras.logger.info("Recipe[" + input + "," + press + "] as input " + this.category);
            return;
        }
        ContainerInputRecipe recipe = new ContainerInputRecipe(input, press, output, id);
        if (!this.validContainers.containsKey(press.func_77977_a())) {
            this.validContainers.put(press.func_77977_a(), press);
        }
        this.recipes.add(recipe);
        this.recipeMap.put(id, recipe);
        for (ItemStack stack : input.getInputs()) {
            this.validInputs.put(new CompareableStack(stack), input);
        }
    }

    public static String getRecipeID(Set<String> ids, String base, int index) {
        String newString = base;
        if (index > 0) {
            newString = newString + "_" + index;
        }
        if (ids.contains(newString)) {
            return ContainerInputRecipeList.getRecipeID(ids, base, index + 1);
        }
        return newString;
    }

    public boolean isValidRecipeInput(ItemStack stack) {
        IRecipeInput input = this.validInputs.get(new CompareableStack(stack));
        if (input == null) {
            return false;
        }
        return input.matches(stack);
    }

    public boolean isValidRecipeContainer(ItemStack stack) {
        return this.validContainers.containsKey(stack.func_77977_a());
    }

    public ContainerInputRecipe getRecipe(Predicate<ContainerInputRecipe> checker) {
        for (ContainerInputRecipe recipe : this.recipes) {
            if (!checker.test(recipe)) continue;
            return recipe;
        }
        return INVALID_RECIPE;
    }

    public ContainerInputRecipe getFromID(String id) {
        return this.recipeMap.get(id);
    }

    private boolean isListInvalid(List<ItemStack> list) {
        if (list.isEmpty()) {
            return true;
        }
        for (ItemStack stack : list) {
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public Collection<ContainerInputRecipe> getRecipeList() {
        return new ArrayList<ContainerInputRecipe>(this.recipes);
    }

    public static class ContainerInputRecipe {
        IRecipeInput input;
        ItemStack press;
        MachineOutput outputs;
        String id;

        public ContainerInputRecipe(IRecipeInput input, ItemStack press, MachineOutput outputs, String id) {
            this.input = input;
            this.press = press;
            this.outputs = outputs;
            this.id = id;
        }

        public String getRecipeID() {
            return this.id;
        }

        public IRecipeInput getInput() {
            return this.input;
        }

        public ItemStack getPress() {
            return this.press;
        }

        public boolean matches(ItemStack stack, ItemStack container) {
            return this.input == null ? stack.func_190926_b() : this.input.matches(stack) && this.input.getAmount() <= stack.func_190916_E() && this.press.func_185136_b(container);
        }

        public MachineOutput getOutputs() {
            return this.outputs;
        }
    }
}

