/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAddForestry;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import com.blamejared.mtlib.utils.BaseRemoveForestry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.MoistenerRecipe;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Moistener")
@ModOnly(value="forestry")
@ZenRegister
public class Moistener {
    public static final String name = "Forestry Moistener";
    public static final String nameFuel = "Forestry Moistener (Fuel)";

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int packagingTime) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add((IMoistenerRecipe)new MoistenerRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)output), packagingTime)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    @ZenMethod
    public static void addFuel(IItemStack item, IItemStack product, int moistenerValue, int stage) {
        if (stage >= 0) {
            ModTweaker.LATE_ADDITIONS.add((IAction)new AddFuel(new MoistenerFuel(InputHelper.toStack((IItemStack)item), InputHelper.toStack((IItemStack)product), stage, moistenerValue)));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe add for %s. Stage parameter must positive!", name, item.toString()));
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient moistenerItem) {
        HashMap<ItemStack, MoistenerFuel> fuelItems = new HashMap<ItemStack, MoistenerFuel>();
        for (Map.Entry fuelItem : FuelManager.moistenerResource.entrySet()) {
            if (fuelItem == null || !StackHelper.matches((IIngredient)moistenerItem, (IItemStack)InputHelper.toIItemStack((ItemStack)((MoistenerFuel)fuelItem.getValue()).getItem()))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (MoistenerFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            ModTweaker.LATE_REMOVALS.add((IAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, moistenerItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, MoistenerFuel> {
        public RemoveFuel(Map<ItemStack, MoistenerFuel> recipes) {
            super(Moistener.nameFuel, FuelManager.moistenerResource, recipes);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, MoistenerFuel> {
        public AddFuel(MoistenerFuel fuelEntry) {
            super(Moistener.nameFuel, FuelManager.moistenerResource);
            this.recipes.put(fuelEntry.getItem(), fuelEntry);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class Remove
    extends BaseRemoveForestry<IMoistenerRecipe> {
        private IIngredient output;

        public Remove(IIngredient output) {
            super(Moistener.name, (ICraftingProvider)RecipeManagers.moistenerManager);
            this.output = output;
        }

        public String getRecipeInfo() {
            return this.output.toString();
        }

        public boolean checkIsRecipe(IMoistenerRecipe recipe) {
            return recipe != null && StackHelper.matches((IIngredient)this.output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getProduct()));
        }
    }

    private static class Add
    extends BaseAddForestry<IMoistenerRecipe> {
        public Add(IMoistenerRecipe recipe) {
            super(Moistener.name, (ICraftingProvider)RecipeManagers.moistenerManager, (IForestryRecipe)recipe);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)((IMoistenerRecipe)this.recipe).getProduct());
        }
    }
}

