/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic;

import icbm.classic.CommonProxy;
import icbm.classic.client.ICBMCreativeTab;
import icbm.classic.command.CommandICBM;
import icbm.classic.config.ConfigItems;
import icbm.classic.content.blocks.BlockConcrete;
import icbm.classic.content.blocks.BlockGlassButton;
import icbm.classic.content.blocks.BlockGlassPressurePlate;
import icbm.classic.content.blocks.BlockReinforcedGlass;
import icbm.classic.content.blocks.BlockSpikes;
import icbm.classic.content.entity.EntityBombCart;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.entity.mobs.EntityXmasCreeper;
import icbm.classic.content.entity.mobs.EntityXmasRPG;
import icbm.classic.content.entity.mobs.EntityXmasSkeleton;
import icbm.classic.content.entity.mobs.EntityXmasSkeletonBoss;
import icbm.classic.content.entity.mobs.EntityXmasSnowman;
import icbm.classic.content.entity.mobs.EntityXmasZombie;
import icbm.classic.content.entity.mobs.EntityXmasZombieBoss;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.thread2.WorkerThreadManager;
import icbm.classic.content.explosive.tile.BlockExplosive;
import icbm.classic.content.explosive.tile.ItemBlockExplosive;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import icbm.classic.content.items.ItemAntidote;
import icbm.classic.content.items.ItemBattery;
import icbm.classic.content.items.ItemBombCart;
import icbm.classic.content.items.ItemCrafting;
import icbm.classic.content.items.ItemDefuser;
import icbm.classic.content.items.ItemGrenade;
import icbm.classic.content.items.ItemLaserDetonator;
import icbm.classic.content.items.ItemMissile;
import icbm.classic.content.items.ItemRadarGun;
import icbm.classic.content.items.ItemRemoteDetonator;
import icbm.classic.content.items.ItemRocketLauncher;
import icbm.classic.content.items.ItemSignalDisrupter;
import icbm.classic.content.items.ItemTracker;
import icbm.classic.content.machines.battery.BlockBattery;
import icbm.classic.content.machines.battery.TileEntityBattery;
import icbm.classic.content.machines.emptower.BlockEmpTower;
import icbm.classic.content.machines.emptower.TileEMPTower;
import icbm.classic.content.machines.launcher.base.BlockLauncherBase;
import icbm.classic.content.machines.launcher.base.TileLauncherBase;
import icbm.classic.content.machines.launcher.cruise.BlockCruiseLauncher;
import icbm.classic.content.machines.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.machines.launcher.frame.BlockLaunchFrame;
import icbm.classic.content.machines.launcher.frame.TileLauncherFrame;
import icbm.classic.content.machines.launcher.screen.BlockLaunchScreen;
import icbm.classic.content.machines.launcher.screen.TileLauncherScreen;
import icbm.classic.content.machines.radarstation.BlockRadarStation;
import icbm.classic.content.machines.radarstation.TileRadarStation;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.content.multiblock.BlockMultiblock;
import icbm.classic.content.multiblock.TileMulti;
import icbm.classic.content.potion.ContagiousPoison;
import icbm.classic.content.potion.PoisonContagion;
import icbm.classic.content.potion.PoisonFrostBite;
import icbm.classic.content.potion.PoisonToxin;
import icbm.classic.lib.emp.CapabilityEMP;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.energy.system.EnergySystemFE;
import icbm.classic.lib.network.netty.PacketManager;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.item.ItemBlockRotatedMultiTile;
import icbm.classic.prefab.item.ItemBlockSubTypes;
import icbm.classic.prefab.item.ItemICBMBase;
import icbm.classic.prefab.item.LootEntryItemStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="icbmclassic", name="ICBM-Classic", version="1.12.2-3.3.0.65", dependencies="", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public final class ICBMClassic {
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    @Mod.Instance(value="icbmclassic")
    public static ICBMClassic INSTANCE;
    @Mod.Metadata(value="icbmclassic")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="icbm.classic.client.ClientProxy", serverSide="icbm.classic.CommonProxy")
    public static CommonProxy proxy;
    public static final String DOMAIN = "icbmclassic";
    public static final String PREFIX = "icbmclassic:";
    public static final String MAJOR_VERSION = "3";
    public static final String MINOR_VERSION = "3";
    public static final String REVISION_VERSION = "0";
    public static final String BUILD_VERSION = "65";
    public static final String MC_VERSION = "1.12.2";
    public static final String VERSION = "1.12.2-3.3.0.65";
    public static final String DEPENDENCIES = "";
    public static final String TEXTURE_DIRECTORY = "textures/";
    public static final String GUI_DIRECTORY = "textures/gui/";
    public static final int ENTITY_ID_PREFIX = 50;
    public static final int MAP_HEIGHT = 255;
    protected static Logger logger;
    private static int nextEntityID;
    public static final PacketManager packetHandler;
    public static Block blockRadioactive;
    public static Block blockGlassPlate;
    public static Block blockGlassButton;
    public static Block blockSpikes;
    public static Block blockCamo;
    public static Block blockConcrete;
    public static Block blockReinforcedGlass;
    public static Block blockExplosive;
    public static Block blockLaunchBase;
    public static Block blockLaunchScreen;
    public static Block blockLaunchSupport;
    public static Block blockRadarStation;
    public static Block blockEmpTower;
    public static Block blockCruiseLauncher;
    public static Block blockMissileCoordinator;
    public static Block blockBattery;
    public static Block multiBlock;
    public static Item itemAntidote;
    public static Item itemSignalDisrupter;
    public static Item itemTracker;
    public static Item itemMissile;
    public static Item itemDefuser;
    public static Item itemRadarGun;
    public static Item itemRemoteDetonator;
    public static Item itemLaserDesignator;
    public static Item itemRocketLauncher;
    public static Item itemGrenade;
    public static Item itemBombCart;
    public static Item itemSulfurDust;
    public static Item itemSaltpeterDust;
    public static Item itemPoisonPowder;
    public static Item itemBattery;
    public static ItemCrafting itemIngot;
    public static ItemCrafting itemIngotClump;
    public static ItemCrafting itemPlate;
    public static ItemCrafting itemCircuit;
    public static ItemCrafting itemWire;
    public static final ContagiousPoison poisonous_potion;
    public static final ContagiousPoison contagios_potion;
    public static final ICBMCreativeTab CREATIVE_TAB;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        itemGrenade = new ItemGrenade();
        event.getRegistry().register((IForgeRegistryEntry)itemGrenade);
        itemBombCart = new ItemBombCart();
        event.getRegistry().register((IForgeRegistryEntry)itemBombCart);
        itemPoisonPowder = new ItemICBMBase("poisonPowder");
        event.getRegistry().register((IForgeRegistryEntry)itemPoisonPowder);
        itemSulfurDust = new ItemICBMBase("sulfurDust");
        event.getRegistry().register((IForgeRegistryEntry)itemSulfurDust);
        itemSaltpeterDust = new ItemICBMBase("saltpeter");
        event.getRegistry().register((IForgeRegistryEntry)itemSaltpeterDust);
        itemAntidote = new ItemAntidote();
        event.getRegistry().register((IForgeRegistryEntry)itemAntidote);
        itemSignalDisrupter = new ItemSignalDisrupter();
        event.getRegistry().register((IForgeRegistryEntry)itemSignalDisrupter);
        itemTracker = new ItemTracker();
        event.getRegistry().register((IForgeRegistryEntry)itemTracker);
        itemDefuser = new ItemDefuser();
        event.getRegistry().register((IForgeRegistryEntry)itemDefuser);
        itemRadarGun = new ItemRadarGun();
        event.getRegistry().register((IForgeRegistryEntry)itemRadarGun);
        itemRemoteDetonator = new ItemRemoteDetonator();
        event.getRegistry().register((IForgeRegistryEntry)itemRemoteDetonator);
        itemLaserDesignator = new ItemLaserDetonator();
        event.getRegistry().register((IForgeRegistryEntry)itemLaserDesignator);
        itemRocketLauncher = new ItemRocketLauncher();
        event.getRegistry().register((IForgeRegistryEntry)itemRocketLauncher);
        itemMissile = new ItemMissile();
        event.getRegistry().register((IForgeRegistryEntry)itemMissile);
        event.getRegistry().register(new ItemBlock(blockGlassPlate).setRegistryName(blockGlassPlate.getRegistryName()));
        event.getRegistry().register(new ItemBlock(blockGlassButton).setRegistryName(blockGlassButton.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockSubTypes(blockSpikes));
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockSubTypes(blockConcrete));
        event.getRegistry().register(new ItemBlock(blockReinforcedGlass).setRegistryName(blockReinforcedGlass.getRegistryName()));
        event.getRegistry().register(new ItemBlockExplosive(blockExplosive).setRegistryName(blockExplosive.getRegistryName()));
        event.getRegistry().register(new ItemBlock(blockEmpTower).setRegistryName(blockEmpTower.getRegistryName()));
        event.getRegistry().register(new ItemBlock(blockRadarStation).setRegistryName(blockRadarStation.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockSubTypes(blockLaunchSupport));
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockRotatedMultiTile(blockLaunchBase, e -> TileLauncherBase.getLayoutOfMultiBlock(e)));
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockSubTypes(blockLaunchScreen));
        event.getRegistry().register((IForgeRegistryEntry)new ItemBlockSubTypes(blockBattery));
        event.getRegistry().register(new ItemBlock(blockCruiseLauncher).setRegistryName(blockCruiseLauncher.getRegistryName()));
        if (ConfigItems.ENABLE_CRAFTING_ITEMS) {
            if (ConfigItems.ENABLE_INGOTS_ITEMS) {
                itemIngot = new ItemCrafting("ingot", "steel", "copper");
                event.getRegistry().register((IForgeRegistryEntry)itemIngot);
                itemIngotClump = new ItemCrafting("clump", "steel");
                event.getRegistry().register((IForgeRegistryEntry)itemIngotClump);
                itemIngot.registerOreNames(new String[0]);
            }
            if (ConfigItems.ENABLE_PLATES_ITEMS) {
                itemPlate = new ItemCrafting("plate", "steel", "iron");
                event.getRegistry().register((IForgeRegistryEntry)itemPlate);
                itemPlate.registerOreNames("iron");
            }
            if (ConfigItems.ENABLE_CIRCUIT_ITEMS) {
                itemCircuit = new ItemCrafting("circuit", "basic", "advanced", "elite");
                event.getRegistry().register((IForgeRegistryEntry)itemCircuit);
                itemCircuit.registerOreNames(new String[0]);
            }
            if (ConfigItems.ENABLE_WIRES_ITEMS) {
                itemWire = new ItemCrafting("wire", "copper", "gold");
                event.getRegistry().register((IForgeRegistryEntry)itemWire);
                itemWire.registerOreNames(new String[0]);
            }
        }
        if (ConfigItems.ENABLE_BATTERY) {
            itemBattery = new ItemBattery();
            event.getRegistry().register((IForgeRegistryEntry)itemBattery);
        }
        ICBMClassic.CREATIVE_TAB.itemStack = new ItemStack(itemMissile);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        blockGlassPlate = new BlockGlassPressurePlate();
        event.getRegistry().register((IForgeRegistryEntry)blockGlassPlate);
        blockGlassButton = new BlockGlassButton();
        event.getRegistry().register((IForgeRegistryEntry)blockGlassButton);
        blockSpikes = new BlockSpikes();
        event.getRegistry().register((IForgeRegistryEntry)blockSpikes);
        blockConcrete = new BlockConcrete();
        event.getRegistry().register((IForgeRegistryEntry)blockConcrete);
        blockReinforcedGlass = new BlockReinforcedGlass();
        event.getRegistry().register((IForgeRegistryEntry)blockReinforcedGlass);
        blockExplosive = new BlockExplosive();
        event.getRegistry().register((IForgeRegistryEntry)blockExplosive);
        blockEmpTower = new BlockEmpTower();
        event.getRegistry().register((IForgeRegistryEntry)blockEmpTower);
        blockRadarStation = new BlockRadarStation();
        event.getRegistry().register((IForgeRegistryEntry)blockRadarStation);
        blockLaunchSupport = new BlockLaunchFrame();
        event.getRegistry().register((IForgeRegistryEntry)blockLaunchSupport);
        blockLaunchBase = new BlockLauncherBase();
        event.getRegistry().register((IForgeRegistryEntry)blockLaunchBase);
        blockLaunchScreen = new BlockLaunchScreen();
        event.getRegistry().register((IForgeRegistryEntry)blockLaunchScreen);
        multiBlock = new BlockMultiblock();
        event.getRegistry().register((IForgeRegistryEntry)multiBlock);
        blockBattery = new BlockBattery();
        event.getRegistry().register((IForgeRegistryEntry)blockBattery);
        blockCruiseLauncher = new BlockCruiseLauncher();
        event.getRegistry().register((IForgeRegistryEntry)blockCruiseLauncher);
        GameRegistry.registerTileEntity(TileEntityExplosive.class, (String)"icbmclassic:explosive");
        GameRegistry.registerTileEntity(TileEMPTower.class, (String)"icbmclassic:emptower");
        GameRegistry.registerTileEntity(TileRadarStation.class, (String)"icbmclassic:radarstation");
        GameRegistry.registerTileEntity(TileLauncherFrame.class, (String)"icbmclassic:launcherframe");
        GameRegistry.registerTileEntity(TileLauncherBase.class, (String)"icbmclassic:launcherbase");
        GameRegistry.registerTileEntity(TileLauncherScreen.class, (String)"icbmclassic:launcherscreen");
        GameRegistry.registerTileEntity(TileMulti.class, (String)"icbmclassic:multiblock");
        GameRegistry.registerTileEntity(TileEntityBattery.class, (String)"icbmclassic:batterybox");
        GameRegistry.registerTileEntity(TileCruiseLauncher.class, (String)"icbmclassic:cruiseLauncher");
    }

    @SubscribeEvent
    public static void registerEntity(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityFlyingBlock.class, "block.gravity", 128, 15));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityFragments.class, "block.fragment", 40, 8));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityExplosive.class, "block.explosive", 50, 5));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityMissile.class, "missile", 500, 1));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityExplosion.class, "holder.explosion", 100, 5));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityLightBeam.class, "beam.light", 80, 5));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityGrenade.class, "item.grenade", 50, 5));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityBombCart.class, "cart.bomb", 50, 2));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityPlayerSeat.class, "holder.seat", 50, 2));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildMobEntry(EntityXmasSkeleton.class, "skeleton.xmas.elf", Color.GREEN, Color.CYAN));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildMobEntry(EntityXmasSkeletonBoss.class, "skeleton.xmas.boss", Color.GREEN, Color.CYAN));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildMobEntry(EntityXmasSnowman.class, "skeleton.xmas.snowman", Color.BLACK, Color.CYAN));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildMobEntry(EntityXmasZombie.class, "zombie.xmas.elf", Color.RED, Color.CYAN));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildMobEntry(EntityXmasZombieBoss.class, "zombie.xmas.boss", Color.RED, Color.CYAN));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildMobEntry(EntityXmasCreeper.class, "zombie.xmas.creeper", Color.RED, Color.CYAN));
        event.getRegistry().register((IForgeRegistryEntry)ICBMClassic.buildEntityEntry(EntityXmasRPG.class, "skeleton.snowman.rocket", 64, 1));
    }

    private static EntityEntry buildEntityEntry(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.name(PREFIX + entityName);
        builder.id(new ResourceLocation(DOMAIN, entityName), nextEntityID++);
        builder.tracker(trackingRange, updateFrequency, true);
        builder.entity(entityClass);
        return builder.build();
    }

    private static EntityEntry buildMobEntry(Class<? extends Entity> entityClass, String entityName, Color p, Color s) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.name(PREFIX + entityName);
        builder.id(new ResourceLocation(DOMAIN, entityName), nextEntityID++);
        builder.tracker(64, 1, true);
        builder.egg(p.getRGB(), s.getRGB());
        builder.entity(entityClass);
        return builder.build();
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        proxy.doLoadModels();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ConfigItems.ENABLE_INGOTS_ITEMS) {
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)itemIngotClump, 1, 0), (ItemStack)new ItemStack((Item)itemIngot, 1, 0), (float)0.1f);
        }
        if (ConfigItems.ENABLE_PLATES_ITEMS) {
            GameRegistry.addSmelting((ItemStack)itemPlate.getStack("iron", 1), (ItemStack)new ItemStack(Items.field_151042_j), (float)0.0f);
        }
    }

    @SubscribeEvent
    public static void registerLoot(LootTableLoadEvent event) {
        LootPool lootPool;
        String VANILLA_LOOT_POOL_ID = "main";
        if (event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186422_d)) {
            LootPool lootPool2;
            if (ConfigItems.ENABLE_LOOT_DROPS && (lootPool2 = event.getTable().getPool("main")) != null) {
                if (ConfigItems.ENABLE_INGOTS_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:ingot.copper", itemIngot.getStack("copper", 10), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:ingot.steel", itemIngot.getStack("steel", 10), 20, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_PLATES_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:plate.steel", itemPlate.getStack("steel", 5), 30, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_WIRES_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:wire.copper", itemWire.getStack("copper", 20), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:wire.gold", itemWire.getStack("gold", 15), 30, 3, new LootCondition[0]));
                }
                if (ConfigItems.ENABLE_CIRCUIT_ITEMS) {
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.basic", itemCircuit.getStack("basic", 15), 15, 5, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.advanced", itemCircuit.getStack("advanced", 11), 30, 3, new LootCondition[0]));
                    lootPool2.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:circuit.elite", itemCircuit.getStack("elite", 8), 30, 3, new LootCondition[0]));
                }
            }
        } else if (event.getName().equals((Object)LootTableList.field_186434_p) && ConfigItems.ENABLE_SULFUR_LOOT_DROPS && (lootPool = event.getTable().getPool("main")) != null) {
            lootPool.addEntry((LootEntry)new LootEntryItemStack("icbmclassic:sulfur", new ItemStack(itemSulfurDust, 10, 0), 2, 0, new LootCondition[0]));
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        EnergySystem.register(new EnergySystemFE());
        CapabilityEMP.register();
        MinecraftForge.EVENT_BUS.register((Object)RadarRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RadioRegistry.INSTANCE);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        packetHandler.init();
        CREATIVE_TAB.init();
        this.setModMetadata(DOMAIN, "ICBM-Classic", metadata);
        OreDictionary.registerOre((String)"dustSulfur", (ItemStack)new ItemStack(itemSulfurDust));
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)new ItemStack(itemSaltpeterDust));
        PoisonToxin.INSTANCE = MobEffects.field_76436_u;
        PoisonContagion.INSTANCE = MobEffects.field_76436_u;
        PoisonFrostBite.INSTANCE = MobEffects.field_76436_u;
        if (itemGrenade != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)itemGrenade, (Object)new IBehaviorDispenseItem(){

                public ItemStack func_82482_a(IBlockSource blockSource, ItemStack itemStack) {
                    World world = blockSource.func_82618_k();
                    if (!world.field_72995_K) {
                        EnumFacing enumFacing = (EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                        EntityGrenade entity = new EntityGrenade(world, new Pos(blockSource.func_180699_d()), Explosives.get(itemStack.func_77952_i()));
                        entity.setThrowableHeading(enumFacing.func_82601_c(), 0.1f, enumFacing.func_82599_e(), 0.5f, 1.0f);
                        world.func_72838_d((Entity)entity);
                    }
                    itemStack.func_190918_g(1);
                    return itemStack;
                }
            });
        }
        if (itemBombCart != null) {
            BlockDispenser.field_149943_a.func_82595_a((Object)itemBombCart, (Object)new BehaviorDefaultDispenseItem(){
                private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    double heightDelta;
                    BlockRailBase.EnumRailDirection rail;
                    EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                    World world = source.func_82618_k();
                    double x = source.func_82615_a() + (double)enumfacing.func_82601_c() * 1.125;
                    double y = Math.floor(source.func_82617_b()) + (double)enumfacing.func_96559_d();
                    double z = source.func_82616_c() + (double)enumfacing.func_82599_e() * 1.125;
                    BlockPos blockpos = source.func_180699_d().func_177972_a(enumfacing);
                    IBlockState iblockstate = world.func_180495_p(blockpos);
                    BlockRailBase.EnumRailDirection enumRailDirection = rail = iblockstate.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.func_177230_c()).getRailDirection((IBlockAccess)world, blockpos, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                    if (BlockRailBase.func_176563_d((IBlockState)iblockstate)) {
                        heightDelta = rail.func_177018_c() ? 0.6 : 0.1;
                    } else {
                        if (iblockstate.func_185904_a() != Material.field_151579_a || !BlockRailBase.func_176563_d((IBlockState)world.func_180495_p(blockpos.func_177977_b()))) {
                            return this.behaviourDefaultDispenseItem.func_82482_a(source, stack);
                        }
                        IBlockState blockB = world.func_180495_p(blockpos.func_177977_b());
                        BlockRailBase.EnumRailDirection railB = blockB.func_177230_c() instanceof BlockRailBase ? ((BlockRailBase)blockB.func_177230_c()).getRailDirection((IBlockAccess)world, blockpos.func_177977_b(), blockB, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                        heightDelta = enumfacing != EnumFacing.DOWN && railB.func_177018_c() ? -0.4 : -0.9;
                    }
                    EntityBombCart cart = new EntityBombCart(world, x, y + heightDelta, z, Explosives.get(stack.func_77952_i()));
                    if (stack.func_82837_s()) {
                        cart.func_96094_a(stack.func_82833_r());
                    }
                    world.func_72838_d((Entity)cart);
                    stack.func_190918_g(1);
                    return stack;
                }
            });
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    public void setModMetadata(String id, String name, ModMetadata metadata) {
        metadata.modId = id;
        metadata.name = name;
        metadata.description = "ICBM is a Minecraft Mod that introduces intercontinental ballistic missiles to Minecraft. But the fun doesn't end there! This mod also features many different explosives, missiles and machines classified in three different tiers. If strategic warfare, carefully coordinated airstrikes, messing with matter and general destruction are up your alley, then this mod is for you!";
        metadata.url = "http://www.builtbroken.com/";
        metadata.logoFile = "/icbm_logo.png";
        metadata.version = VERSION;
        metadata.authorList = Arrays.asList("Calclavia", "DarkGuardsman aka Darkcow");
        metadata.credits = "Please visit the website.";
        metadata.autogenerated = false;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new CommandICBM("icbmc"));
        if (!Loader.isModLoaded((String)"icbm")) {
            serverCommandManager.func_71560_a((ICommand)new CommandICBM("icbm"));
        }
        WorkerThreadManager.INSTANCE = new WorkerThreadManager(4);
        WorkerThreadManager.INSTANCE.startThreads();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStoppingEvent event) {
        WorkerThreadManager.INSTANCE.killThreads();
    }

    public static Logger logger() {
        return logger;
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.") && !element.getClassName().startsWith("com.builtbroken.mc.testing.junit.VoltzTestRunner")) continue;
            return true;
        }
        return false;
    }

    static {
        logger = LogManager.getLogger((String)DOMAIN);
        nextEntityID = 50;
        packetHandler = new PacketManager(DOMAIN);
        blockRadioactive = Blocks.field_150391_bh;
        poisonous_potion = new ContagiousPoison("Chemical", 0, false);
        contagios_potion = new ContagiousPoison("Contagious", 1, true);
        CREATIVE_TAB = new ICBMCreativeTab(DOMAIN);
    }
}

