/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.launcher.screen;

import icbm.classic.ICBMClassic;
import icbm.classic.api.items.IWorldPosItem;
import icbm.classic.content.items.ItemLaserDetonator;
import icbm.classic.content.items.ItemRemoteDetonator;
import icbm.classic.content.machines.launcher.screen.TileLauncherScreen;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.BlockICBM;
import icbm.classic.prefab.tile.EnumTier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaunchScreen
extends BlockICBM {
    public BlockLaunchScreen() {
        super("launcherscreen");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileLauncherScreen) {
            TileLauncherScreen screen = (TileLauncherScreen)tileEntity;
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b() == Items.field_151137_ax) {
                if (screen.canLaunch()) {
                    screen.launch();
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.failedToFire")));
                    String translation = LanguageUtility.getLocal("chat.launcher.status");
                    translation = translation.replace("%1", screen.getStatus());
                    player.func_145747_a((ITextComponent)new TextComponentString(translation));
                }
            } else if (stack.func_77973_b() instanceof ItemRemoteDetonator) {
                ((ItemRemoteDetonator)stack.func_77973_b()).setBroadCastHz(stack, screen.getFrequency());
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolFrequencySet").replace("%1", "" + screen.getFrequency())));
            } else if (stack.func_77973_b() instanceof ItemLaserDetonator) {
                ((ItemLaserDetonator)stack.func_77973_b()).setBroadCastHz(stack, screen.getFrequency());
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolFrequencySet").replace("%1", "" + screen.getFrequency())));
            } else if (stack.func_77973_b() instanceof IWorldPosItem) {
                Location location = ((IWorldPosItem)stack.func_77973_b()).getLocation(stack);
                if (location != null) {
                    if (location.world() == world) {
                        screen.setTarget(new Pos(location.x(), location.y(), location.z()));
                        player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolTargetSet")));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.toolWorldNotMatch")));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(LanguageUtility.getLocal("chat.launcher.noTargetInTool")));
                }
            } else if (screen.launcherBase == null || !screen.launcherBase.tryInsertMissile(player, hand, player.func_184586_b(hand))) {
                player.openGui((Object)ICBMClassic.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileLauncherScreen();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumTier)((Object)state.func_177229_b((IProperty)TIER_PROP))).ordinal();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION_PROP, TIER_PROP});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumTier tier = EnumTier.ONE;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileLauncherScreen) {
            tier = ((TileLauncherScreen)tile)._tier;
        }
        return state.func_177226_a((IProperty)TIER_PROP, (Comparable)((Object)tier));
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        ItemStack stack = placer.func_184586_b(hand);
        return state.func_177226_a((IProperty)TIER_PROP, (Comparable)((Object)EnumTier.get(stack.func_77952_i())));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileLauncherScreen) {
            ((TileLauncherScreen)tile)._tier = EnumTier.get(stack.func_77952_i());
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }
}

