/*
 * Decompiled with CFR 0.152.
 */
package bq_rf.block;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import bq_rf.block.RSItemHandler;
import bq_rf.core.BQRF;
import bq_rf.network.PktHandlerRfTile;
import bq_rf.tasks.IRfTask;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileRfStation
extends TileEntity
implements IEnergyStorage,
ISidedInventory,
ITickable {
    private final IItemHandler itemHandler;
    private NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private boolean needsUpdate = false;
    public UUID owner;
    public int questID;
    public int taskID;
    private DBEntry<IQuest> qCached;

    public TileRfStation() {
        this.itemHandler = new RSItemHandler(this);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.isSetup() || ((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            return;
        }
        long wtt = this.field_145850_b.func_82737_E();
        if (wtt % 10L == 0L && this.owner != null) {
            QuestCache qc;
            if (wtt % 20L == 0L) {
                this.qCached = null;
            }
            DBEntry<IQuest> q = this.getQuest();
            IRfTask t = this.getTask();
            MinecraftServer server = this.field_145850_b.func_73046_m();
            EntityPlayerMP player = server == null ? null : server.func_184103_al().func_177451_a(this.owner);
            QuestCache questCache = qc = player == null ? null : (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (q != null && t != null && !((ItemStack)this.itemStacks.get(0)).func_190926_b() && ((ItemStack)this.itemStacks.get(1)).func_190926_b()) {
                ItemStack inStack = ((ItemStack)this.itemStacks.get(0)).func_77946_l();
                ItemStack beforeStack = ((ItemStack)this.itemStacks.get(0)).func_77946_l();
                if (this.func_94041_b(0, inStack)) {
                    this.itemStacks.set(0, (Object)t.submitItem(q, this.owner, inStack));
                    if (t.isComplete(this.owner)) {
                        this.reset();
                        this.needsUpdate = true;
                        if (server != null) {
                            server.func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
                        }
                    } else if (!((ItemStack)this.itemStacks.get(0)).equals(beforeStack)) {
                        this.needsUpdate = true;
                    }
                } else {
                    this.itemStacks.set(1, (Object)inStack);
                    this.itemStacks.set(0, (Object)ItemStack.field_190927_a);
                }
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                if (q != null && qc != null) {
                    qc.markQuestDirty(this.questID);
                }
            }
            if (t != null && t.isComplete(this.owner)) {
                this.reset();
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
            }
        }
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (!this.isSetup() || energy <= 0 || ((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            return 0;
        }
        IRfTask t = this.getTask();
        int remainder = 0;
        if (!simulate) {
            remainder = t.submitEnergy(this.getQuest(), this.owner, energy);
            if (t.isComplete(this.owner)) {
                this.needsUpdate = true;
                this.reset();
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
            } else {
                this.needsUpdate = true;
            }
        }
        return energy - remainder;
    }

    public int extractEnergy(int amount, boolean sim) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.isSetup();
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int idx) {
        if (idx < 0 || idx >= this.itemStacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.itemStacks.get(idx);
    }

    public ItemStack func_70298_a(int idx, int amount) {
        return ItemStackHelper.func_188382_a(this.itemStacks, (int)idx, (int)amount);
    }

    public void func_70299_a(int idx, @Nonnull ItemStack stack) {
        if (idx < 0 || idx >= this.itemStacks.size()) {
            return;
        }
        this.itemStacks.set(idx, (Object)stack);
    }

    public String func_70005_c_() {
        return BQRF.rfStation.func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.owner == null || player.func_110124_au().equals(this.owner);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_191420_l() {
        return this.itemStacks.isEmpty();
    }

    public boolean func_94041_b(int idx, ItemStack stack) {
        if (idx != 0) {
            return false;
        }
        return stack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() > 0;
    }

    public DBEntry<IQuest> getQuest() {
        IQuest tmp;
        if (this.questID < 0) {
            return null;
        }
        if (this.qCached == null && (tmp = (IQuest)((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getValue(this.questID)) != null) {
            this.qCached = new DBEntry(this.questID, (Object)tmp);
        }
        return this.qCached;
    }

    public ITask getRawTask() {
        DBEntry<IQuest> q = this.getQuest();
        if (q == null || this.taskID < 0) {
            return null;
        }
        return (ITask)((IQuest)q.getValue()).getTasks().getValue(this.taskID);
    }

    public IRfTask getTask() {
        ITask t = this.getRawTask();
        return t instanceof IRfTask ? (IRfTask)t : null;
    }

    public void setupTask(UUID owner, IQuest quest, ITask task) {
        if (owner == null || quest == null || task == null) {
            this.reset();
        }
        this.questID = ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest);
        this.qCached = new DBEntry(this.questID, (Object)quest);
        this.taskID = quest.getTasks().getID((Object)task);
        if (this.questID < 0 || this.taskID < 0) {
            this.reset();
            return;
        }
        this.owner = owner;
        this.func_70296_d();
    }

    public boolean isSetup() {
        return this.owner != null && this.questID >= 0 && this.taskID >= 0;
    }

    public void reset() {
        this.owner = null;
        this.questID = -1;
        this.taskID = -1;
        this.qCached = null;
        this.func_70296_d();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void SyncTile(NBTTagCompound data) {
        if (!this.field_145850_b.field_72995_K) {
            if (data != null) {
                this.func_145839_a(data);
            }
            this.func_70296_d();
            this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 128.0, this.field_145850_b.field_73011_w.getDimension(), (Packet)this.func_189518_D_());
        } else {
            PktHandlerRfTile.sendEdit(this.func_189515_b(new NBTTagCompound()));
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        ItemStackHelper.func_191283_b((NBTTagCompound)tags.func_74775_l("inventory"), this.itemStacks);
        try {
            this.owner = UUID.fromString(tags.func_74779_i("owner"));
        }
        catch (Exception e) {
            this.reset();
            return;
        }
        this.questID = tags.func_74764_b("questID") ? tags.func_74762_e("questID") : -1;
        int n = this.taskID = tags.func_74764_b("task") ? tags.func_74762_e("task") : -1;
        if (!this.isSetup()) {
            this.reset();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        tags.func_74778_a("owner", this.owner != null ? this.owner.toString() : "");
        tags.func_74768_a("questID", this.questID);
        tags.func_74768_a("task", this.taskID);
        tags.func_74782_a("inventory", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.itemStacks));
        return tags;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0 && this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemStacks, (int)index);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemStacks.clear();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(BQRF.rfStation.func_149732_F());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

