/*
 * Decompiled with CFR 0.152.
 */
package bq_rf.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_rf.client.gui.tasks.PanelTaskCharge;
import bq_rf.core.BQRF;
import bq_rf.tasks.IRfTask;
import bq_rf.tasks.factory.FactoryTaskRfCharge;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskRfCharge
implements ITask,
IRfTask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final HashMap<UUID, Long> userProgress = new HashMap();
    public long RF = 100000L;

    public ResourceLocation getFactoryID() {
        return FactoryTaskRfCharge.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_rf.task.rf_charge";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.userProgress.clear();
            this.completeUsers.clear();
        } else {
            this.userProgress.remove(uuid);
            this.completeUsers.remove(uuid);
        }
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_71071_by == null || this.isComplete(pInfo.UUID)) {
            return;
        }
        for (int i = 0; i < pInfo.PLAYER.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = pInfo.PLAYER.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stack = this.submitItem(quest, pInfo.UUID, stack);
            pInfo.PLAYER.field_71071_by.func_70299_a(i, stack);
            if (this.isComplete(pInfo.UUID)) break;
        }
        pInfo.markDirty(Collections.singletonList(quest.getID()));
    }

    @Override
    public ItemStack submitItem(DBEntry<IQuest> quest, UUID owner, ItemStack stack) {
        if (stack.func_190926_b()) {
            return stack;
        }
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (cap == null) {
            return stack;
        }
        Long progress = this.getUsersProgress(owner);
        progress = progress != null ? progress : 0L;
        int requesting = (int)Math.min(Integer.MAX_VALUE, this.RF - progress);
        int extracted = cap.extractEnergy(requesting, false);
        progress = progress + (long)extracted;
        this.setUserProgress(owner, progress);
        if (progress >= this.RF) {
            this.setComplete(owner);
        }
        return stack;
    }

    @Override
    public int submitEnergy(DBEntry<IQuest> quest, UUID owner, int amount) {
        Long progress = this.getUsersProgress(owner);
        progress = progress != null ? progress : 0L;
        int requesting = (int)Math.min(Integer.MAX_VALUE, this.RF - progress);
        int extracted = Math.min(amount, requesting);
        progress = progress + (long)extracted;
        this.setUserProgress(owner, progress);
        if (progress >= this.RF) {
            this.setComplete(owner);
        }
        return amount - extracted;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("rf", this.RF);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.RF = nbt.func_74763_f("rf");
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQRF.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74763_f("value"));
                continue;
            }
            catch (Exception e) {
                BQRF.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Long data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74772_a("value", data.longValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74772_a("value", data.longValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    private void setUserProgress(UUID uuid, Long progress) {
        this.userProgress.put(uuid, progress);
    }

    public Long getUsersProgress(UUID ... uuid) {
        long total = 0L;
        for (UUID mem : uuid) {
            Long l = this.userProgress.get(mem);
            total += l == null ? 0L : l;
        }
        return total;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskCharge(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }
}

