/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.client.gui.editors.panels;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.client.gui.editors.controls.BQButton;
import com.nicjames2378.bqforestry.client.gui.editors.panels.templates.TemplateEmpty;
import com.nicjames2378.bqforestry.client.gui.editors.tasks.abstractions.BQScreenCanvas;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.logic.BigBeeStack;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class PanelBeeGrowth
extends TemplateEmpty {
    private final List<PanelButtonStorage<String>> lstGrowthButtons = new ArrayList<PanelButtonStorage<String>>();
    private final List<PanelTextBox> lstGrowthLabels = new ArrayList<PanelTextBox>();
    private UtilitiesBee.BeeTypes growthLevel = UtilitiesBee.BeeTypes.valueOf(ConfigHandler.cfgBeeType);

    public PanelBeeGrowth() {
        super((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0));
    }

    @Override
    public void initialize(final BQScreenCanvas gui, CanvasEmpty canvas) {
        final BigBeeStack bee = new BigBeeStack(gui.getSelectedItem());
        this.growthLevel = UtilitiesBee.getGrowthLevel(bee.getBaseStack());
        canvas.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(16, 8, 16, -32), 0), QuestTranslation.translate((String)"bqforestry.label.beegrowthstage", (Object[])new Object[0])).setAlignment(1).setColor(PresetColor.TEXT_HEADER.getColor()));
        int lHW = canvas.getTransform().getWidth() / 2;
        int workingY = 18;
        boolean isLeft = true;
        String[] types = UtilitiesBee.getGrowthStages();
        CanvasScrolling cvScrollable = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 20, 8, 30), 0));
        canvas.addPanel((IGuiPanel)cvScrollable);
        PanelVScrollBar vScrollbar = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 20, 0, 30), 0));
        cvScrollable.setScrollDriverY((IValueIO)vScrollbar);
        vScrollbar.setScrollSpeed(ConfigHandler.cfgScrollSpeed);
        canvas.addPanel((IGuiPanel)vScrollbar);
        cvScrollable.addPanel((IGuiPanel)BQScreenCanvas.BUG_FIX1);
        for (int t = 0; t < types.length; ++t) {
            String formattedType = (types[t].equals(this.growthLevel.get()) ? TextFormatting.GREEN : "") + types[t].substring(0, 1).toUpperCase() + types[t].substring(1).toLowerCase();
            PanelTextBox lblBeeType = new PanelTextBox((IGuiRect)new GuiRectangle(lHW + (isLeft ? -66 : 4), Math.floorDiv(t, 2) * 64 + 54 + workingY, 70, 16, -1), formattedType);
            cvScrollable.addPanel((IGuiPanel)lblBeeType);
            this.lstGrowthLabels.add(lblBeeType);
            PanelButtonStorage btnBeeType = new PanelButtonStorage((IGuiRect)new GuiRectangle(lHW + (isLeft ? -70 : 0), Math.floorDiv(t, 2) * 64 + workingY, 70, 64, 0), -1, "", (Object)types[t]);
            btnBeeType.setActive(!types[t].equals(this.growthLevel.get()));
            btnBeeType.setCallback(value -> {
                this.growthLevel = UtilitiesBee.BeeTypes.valueOf(value);
                BQ_Forestry.debug("Selecting: " + this.growthLevel.get());
                for (PanelButtonStorage<String> b : this.lstGrowthButtons) {
                    String val = (String)b.getStoredValue();
                    if (val.equals(this.growthLevel.get())) {
                        b.setActive(false);
                        this.lstGrowthLabels.get(this.lstGrowthButtons.indexOf(b)).setText(TextFormatting.GREEN + val.substring(0, 1).toUpperCase() + val.substring(1).toLowerCase());
                        continue;
                    }
                    b.setActive(true);
                    this.lstGrowthLabels.get(this.lstGrowthButtons.indexOf(b)).setText(val.substring(0, 1).toUpperCase() + val.substring(1).toLowerCase());
                }
            });
            btnBeeType.setIcon((IGuiTexture)new ItemTexture(new BigItemStack(UtilitiesBee.getBaseBee(UtilitiesBee.getTrait(bee.getBaseStack(), EnumBeeChromosome.SPECIES, true)[0], UtilitiesBee.BeeTypes.valueOf((String)btnBeeType.getStoredValue())))), 8);
            cvScrollable.addPanel((IGuiPanel)btnBeeType);
            this.lstGrowthButtons.add((PanelButtonStorage<String>)btnBeeType);
            isLeft ^= true;
        }
        BQButton.ConfirmButton doneButton = new BQButton.ConfirmButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(4, -28, 4, 4), 0), -1, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])){

            public void onButtonClick() {
                BQ_Forestry.debug(String.format("Setting Bee Growth: Current=%1$s, New=%2$s", new Object[]{bee.getBeeType(), PanelBeeGrowth.this.growthLevel}));
                gui.updateTaskItem(bee.setType(PanelBeeGrowth.this.growthLevel));
            }
        };
        canvas.addPanel((IGuiPanel)doneButton);
    }
}

