/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.client.gui.editors.panels;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IFieldFilter;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.client.gui.editors.controls.BQButton;
import com.nicjames2378.bqforestry.client.gui.editors.panels.canvas.CanvasBeeDatabase;
import com.nicjames2378.bqforestry.client.gui.editors.panels.templates.TemplateEmpty;
import com.nicjames2378.bqforestry.client.gui.editors.tasks.abstractions.BQScreenCanvas;
import com.nicjames2378.bqforestry.config.ConfigHandler;
import com.nicjames2378.bqforestry.logic.BigBeeStack;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class PanelBeeSpecies
extends TemplateEmpty {
    private final List<PanelButtonStorage<String>> lstSpeciesButtons = new ArrayList<PanelButtonStorage<String>>();
    private String species = "forestry.speciesCommon";

    public PanelBeeSpecies() {
        super((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0));
    }

    public PanelBeeSpecies(IGuiRect rect) {
        super(rect);
    }

    @Override
    public void initialize(final BQScreenCanvas gui, CanvasEmpty canvas) {
        this.species = UtilitiesBee.getTrait(gui.getSelectedItem(), EnumBeeChromosome.SPECIES, true)[0];
        final BigBeeStack bee = new BigBeeStack(gui.getSelectedItem());
        CanvasBeeDatabase cvBeeDB = new CanvasBeeDatabase((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 32), 1)){

            public void refreshSearch() {
                super.refreshSearch();
            }

            protected boolean addResult(IAllele entry, int index, int cachedWidth) {
                String beeUID = entry.getUID();
                this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, index * 24, 24, 24, -1), (IGuiTexture)new ItemTexture(new BigItemStack(UtilitiesBee.getBaseBee(beeUID, bee.getBeeType())))));
                this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, index * 24, 24, 24, 0), PresetTexture.ITEM_FRAME.getTexture()));
                PanelButtonStorage btnBeeSpecies = new PanelButtonStorage((IGuiRect)new GuiRectangle(24, index * 24, cachedWidth - 24, 24, 0), -1, entry.getAlleleName(), (Object)entry.getUID());
                btnBeeSpecies.setActive(!beeUID.equals(PanelBeeSpecies.this.species));
                btnBeeSpecies.setCallback(value -> {
                    PanelBeeSpecies.this.species = value;
                    Iterator iterator = PanelBeeSpecies.this.lstSpeciesButtons.iterator();
                    while (iterator.hasNext()) {
                        PanelButtonStorage b;
                        b.setActive(!((String)(b = (PanelButtonStorage)iterator.next()).getStoredValue()).equals(PanelBeeSpecies.this.species));
                    }
                });
                btnBeeSpecies.setTooltip(PanelBeeSpecies.this.getBeeTooltip(entry.getModID(), entry.getUID()));
                this.addPanel((IGuiPanel)btnBeeSpecies);
                PanelBeeSpecies.this.lstSpeciesButtons.add(btnBeeSpecies);
                return true;
            }
        };
        canvas.addPanel((IGuiPanel)cvBeeDB);
        PanelTextField txtSearch = new PanelTextField((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -18), 0), "", (IFieldFilter)FieldFilterString.INSTANCE);
        txtSearch.setCallback(arg_0 -> ((CanvasBeeDatabase)cvBeeDB).setSearchFilter(arg_0)).setWatermark("Search...");
        canvas.addPanel((IGuiPanel)txtSearch);
        PanelVScrollBar scBeeBar = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 18, 0, 32), 0));
        cvBeeDB.setScrollDriverY((IValueIO)scBeeBar);
        scBeeBar.setScrollSpeed(ConfigHandler.cfgScrollSpeed);
        canvas.addPanel((IGuiPanel)scBeeBar);
        BQButton.ConfirmButton doneButton = new BQButton.ConfirmButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(4, -28, 4, 4), 0), -1, QuestTranslation.translate((String)"gui.done", (Object[])new Object[0])){

            public void onButtonClick() {
                BQ_Forestry.debug(String.format("ControlSpecies: Setting Species for item #%1$s: - %2$s", gui.getSelectedIndex(), PanelBeeSpecies.this.species));
                UtilitiesBee.writeTrait(bee.getBaseStack(), EnumBeeChromosome.SPECIES, PanelBeeSpecies.this.species);
                gui.updateTaskItem(bee);
            }
        };
        canvas.addPanel((IGuiPanel)doneButton);
    }

    private List<String> getBeeTooltip(String modID, String uid) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(TextFormatting.GOLD).append("ModID: ").append(TextFormatting.AQUA).append(modID);
        ret.add(sb.toString());
        sb.delete(0, sb.length());
        sb.append(TextFormatting.GOLD).append("UID: ").append(TextFormatting.AQUA).append(uid);
        ret.add(sb.toString());
        return ret;
    }
}

