/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.client.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import com.nicjames2378.bqforestry.BQ_Forestry;
import com.nicjames2378.bqforestry.logic.BigBeeStack;
import com.nicjames2378.bqforestry.tasks.TaskForestryRetrieval;
import com.nicjames2378.bqforestry.utils.StringUtils;
import com.nicjames2378.bqforestry.utils.UtilitiesBee;
import forestry.api.apiculture.EnumBeeChromosome;
import java.util.ArrayList;
import java.util.UUID;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Optional;

public class PanelTaskForestryRetrieval
extends CanvasEmpty {
    private final TaskForestryRetrieval task;

    public PanelTaskForestryRetrieval(IGuiRect rect, TaskForestryRetrieval task) {
        super(rect);
        this.task = task;
    }

    private static String getInfoString(String translationKey, ItemStack bee, EnumBeeChromosome chromosome) {
        String GOLD = "%%1";
        String AQUA = "%%2";
        String DIV = GOLD.concat(", ").concat(AQUA);
        StringUtils.IStringStyle style = str -> str.substring(StringUtils.indexOfFirstCapital(str));
        String ret = GOLD.concat(QuestTranslation.translate((String)translationKey, (Object[])new Object[0])).concat(": ").concat(AQUA);
        if (chromosome == EnumBeeChromosome.SPECIES) {
            return ret.concat(UtilitiesBee.getDisplayName(bee)).concat(" (" + UtilitiesBee.getTrait(bee, chromosome, true)[0]) + ")";
        }
        return ret.concat(StringUtils.flattenArray(UtilitiesBee.getTrait(bee, chromosome, false), DIV, style));
    }

    public void initPanel() {
        super.initPanel();
        String doConsume = (this.task.consume ? TextFormatting.RED : TextFormatting.GREEN) + QuestTranslation.translate((String)(this.task.consume ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        this.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 1), QuestTranslation.translate((String)"bqforestry.btn.consume", (Object[])new Object[]{doConsume})).setColor(PresetColor.TEXT_MAIN.getColor()));
        CanvasScrolling cvList = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0));
        this.addPanel((IGuiPanel)cvList);
        PanelVScrollBar scList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        this.addPanel((IGuiPanel)scList);
        cvList.setScrollDriverY((IValueIO)scList);
        int listW = cvList.getTransform().getWidth();
        int currentY = 38;
        if (this.task.requiredItems.size() > 0) {
            for (int i = 0; i < this.task.requiredItems.size(); ++i) {
                BigBeeStack beeStack = new BigBeeStack((BigItemStack)this.task.requiredItems.get(i));
                BigItemStack safeStack = UtilitiesBee.getSafeStack((BigItemStack)this.task.requiredItems.get(i));
                String info = this.getInfo(beeStack, i);
                int lines = 1 + StringUtils.getCount(info, "\n");
                int height = (lines + 1) * 9;
                StringUtils.IStringStyle style = str -> str.replaceAll("%%1", TextFormatting.GOLD.toString()).replaceAll("%%2", TextFormatting.AQUA.toString());
                PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, currentY, 32, 32, 0), -1, safeStack, false, true);
                if (BQ_Forestry.hasJEI) {
                    slot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
                }
                cvList.addPanel((IGuiPanel)slot);
                PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(36, currentY + 2, listW - 36, height - 2, 0), style.stylize(info));
                text.setColor(PresetColor.TEXT_MAIN.getColor());
                cvList.addPanel((IGuiPanel)text);
                currentY += height;
            }
        } else {
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(36, currentY + 2, listW - 36, 40, 0), "No  Quest Items Found!");
            text.setColor(PresetColor.TEXT_MAIN.getColor()).setFontSize(12);
            cvList.addPanel((IGuiPanel)text);
        }
    }

    private ArrayList<String> getInfoList(ItemStack bee) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.lifespan", bee, EnumBeeChromosome.LIFESPAN));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.speeds", bee, EnumBeeChromosome.SPEED));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.flowering", bee, EnumBeeChromosome.FLOWERING));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.fertility", bee, EnumBeeChromosome.FERTILITY));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.territory", bee, EnumBeeChromosome.TERRITORY));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.effect", bee, EnumBeeChromosome.EFFECT));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.temp", bee, EnumBeeChromosome.TEMPERATURE_TOLERANCE));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.humidity", bee, EnumBeeChromosome.HUMIDITY_TOLERANCE));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.sleeps", bee, EnumBeeChromosome.NEVER_SLEEPS));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.rain", bee, EnumBeeChromosome.TOLERATES_RAIN));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.dwelling", bee, EnumBeeChromosome.CAVE_DWELLING));
        info.add(PanelTaskForestryRetrieval.getInfoString("bqforestry.label.bee.flowers", bee, EnumBeeChromosome.FLOWER_PROVIDER));
        return info;
    }

    private String getInfo(BigBeeStack stack, int index) {
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        StringBuilder sb = new StringBuilder();
        sb.append(UtilitiesBee.getSafeStack(stack).getBaseStack().func_82833_r());
        sb.append(" - ");
        if (isComplete || progress[index] >= stack.stackSize) {
            sb.append(TextFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
        } else {
            sb.append(TextFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
        }
        sb.append("\n").append(TextFormatting.GOLD).append("Requirements:\n").append(TextFormatting.RESET);
        ArrayList<String> infoList = this.getInfoList(stack.getBaseStack());
        int numLeft = infoList.size();
        for (String s : infoList) {
            if (!s.toLowerCase().contains("%%2Any".toLowerCase())) {
                sb.append("   ").append(s).append("\n");
                continue;
            }
            --numLeft;
        }
        if (numLeft == 0) {
            sb.append("   ").append("%%2None").append("\n");
        }
        return sb.toString();
    }

    @Optional.Method(modid="jei")
    private void lookupRecipe(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || Internal.getRuntime() == null) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(IFocus.Mode.OUTPUT, (Object)stack));
    }
}

