/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.moistener;

import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.recipes.jei.ForestryRecipeWrapper;
import java.util.ArrayList;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MoistenerRecipeWrapper
extends ForestryRecipeWrapper<IMoistenerRecipe> {
    private final MoistenerFuel fuel;

    public MoistenerRecipeWrapper(IMoistenerRecipe recipe, MoistenerFuel fuel) {
        super(recipe);
        this.fuel = fuel;
    }

    public void getIngredients(IIngredients ingredients) {
        IMoistenerRecipe recipe = (IMoistenerRecipe)this.getRecipe();
        ArrayList<ItemStack> itemStackInputs = new ArrayList<ItemStack>();
        itemStackInputs.add(recipe.getResource());
        ItemStack fuelItem = this.fuel.getItem();
        itemStackInputs.add(fuelItem);
        ingredients.setInputs(VanillaTypes.ITEM, itemStackInputs);
        ArrayList<ItemStack> itemStackOutputs = new ArrayList<ItemStack>();
        itemStackOutputs.add(recipe.getProduct());
        ItemStack fuelProduct = this.fuel.getProduct();
        itemStackOutputs.add(fuelProduct);
        ingredients.setOutputs(VanillaTypes.ITEM, itemStackOutputs);
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(FluidRegistry.WATER, recipe.getTimePerItem() / 4));
    }

    public MoistenerFuel getFuel() {
        return this.fuel;
    }
}

