/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.Keybindings;
import com.sosnitzka.taiga.traits.TraitProgressiveStats;
import com.sosnitzka.taiga.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitBerserk
extends TraitProgressiveStats {
    protected static int TICK_PER_STAT = 8;

    public TraitBerserk() {
        super(TraitBerserk.class.getSimpleName().toLowerCase().substring(5), TextFormatting.RED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        if (!data.active) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * 4.0f);
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        if (!data.active) {
            return newDamage;
        }
        return newDamage * 4.0f;
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            EntityLivingBase player = (EntityLivingBase)entity;
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            NBTTagCompound root = TagUtil.getTagSafe((ItemStack)tool);
            TraitProgressiveStats.StatNBT distributed = this.getBonus(root);
            if (data.active) {
                if (!TagUtil.hasEnchantEffect((NBTTagCompound)root)) {
                    TagUtil.setEnchantEffect((NBTTagCompound)root, (boolean)true);
                }
                if (entity instanceof FakePlayer || entity.field_70173_aa % TICK_PER_STAT != 0) {
                    return;
                }
                ToolNBT stat = TagUtil.getToolStats((ItemStack)tool);
                if (random.nextFloat() > 0.8f) {
                    --stat.durability;
                    --distributed.durability;
                } else {
                    ToolHelper.damageTool((ItemStack)tool, (int)1, (EntityLivingBase)player);
                }
                TagUtil.setToolTag((NBTTagCompound)root, (NBTTagCompound)stat.get());
                this.setBonus(root, distributed);
            } else if (TagUtil.hasEnchantEffect((NBTTagCompound)root)) {
                TagUtil.setEnchantEffect((NBTTagCompound)root, (boolean)false);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        World w = event.getWorld();
        ItemStack tool = event.getEntityPlayer().func_184614_ca();
        if (!w.field_72995_K && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier) && Keybindings.altKey.func_151470_d()) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            NBTTagCompound root = TagUtil.getTagSafe((ItemStack)tool);
            TraitProgressiveStats.StatNBT distributed = this.getBonus(root);
            ToolNBT stat = TagUtil.getToolStats((ItemStack)tool);
            if (data.active) {
                data.active = false;
                TagUtil.setEnchantEffect((NBTTagCompound)root, (boolean)false);
                TagUtil.setExtraTag((NBTTagCompound)root, (NBTTagCompound)tag);
                data.write(tag);
            } else {
                stat.durability -= 10;
                distributed.durability -= 10;
                TagUtil.setToolTag((NBTTagCompound)root, (NBTTagCompound)stat.get());
                this.setBonus(root, distributed);
                data.active = true;
                data.write(tag);
                TagUtil.setExtraTag((NBTTagCompound)root, (NBTTagCompound)tag);
                data.write(tag);
            }
        }
    }
}

