/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.command;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;

public class CommandChangeOwner
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "omchangeowner";
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_71518_a(ICommandSender sender) {
        return "<dimension> <x> <y> <z> <new owner>";
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) {
        if (params.length != 5) {
            PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        try {
            int dimension = Integer.parseInt(params[0]);
            int x = Integer.parseInt(params[1]);
            int y = Integer.parseInt(params[2]);
            int z = Integer.parseInt(params[3]);
            String ownerName = params[4];
            if (DimensionManager.getWorld((int)dimension) == null) {
                PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString("Invalid dimension"));
                return;
            }
            WorldServer worldserver = server.func_71218_a(dimension);
            TileEntity tileEntity = worldserver.func_175625_s(new BlockPos(x, y, z));
            if (tileEntity instanceof TileEntityOwnedBlock) {
                TileEntityOwnedBlock block = (TileEntityOwnedBlock)tileEntity;
                UUID uuid = PlayerUtil.getPlayerUUID(ownerName);
                if (uuid != null) {
                    block.setOwner(new Player(uuid, ownerName));
                    PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString("Block ownership has been updated"));
                } else if (!GeneralUtil.isServerInOnlineMode()) {
                    block.setOwner(new Player(null, ownerName));
                    PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString("Block ownership has been updated"));
                } else {
                    PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString("New owner not valid."));
                }
            } else {
                PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString("No ownable block was found at that location"));
            }
        }
        catch (NumberFormatException e) {
            PlayerUtil.addChatMessage(sender, (ITextComponent)new TextComponentString("Dimension and coordinates must be numbers"));
        }
    }

    public int func_82362_a() {
        return 4;
    }
}

