/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.audience;

import java.util.Collections;
import me.lucko.luckperms.lib.adventure.audience.Audience;
import me.lucko.luckperms.lib.adventure.audience.MessageType;
import me.lucko.luckperms.lib.adventure.bossbar.BossBar;
import me.lucko.luckperms.lib.adventure.inventory.Book;
import me.lucko.luckperms.lib.adventure.sound.Sound;
import me.lucko.luckperms.lib.adventure.sound.SoundStop;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface ForwardingAudience
extends Audience {
    public @NonNull Iterable<? extends Audience> audiences();

    @Override
    default public void sendMessage(@NonNull Component message, @NonNull MessageType type) {
        for (Audience audience : this.audiences()) {
            audience.sendMessage(message, type);
        }
    }

    @Override
    default public void sendActionBar(@NonNull Component message) {
        for (Audience audience : this.audiences()) {
            audience.sendActionBar(message);
        }
    }

    @Override
    default public void showTitle(@NonNull Title title) {
        for (Audience audience : this.audiences()) {
            audience.showTitle(title);
        }
    }

    @Override
    default public void clearTitle() {
        for (Audience audience : this.audiences()) {
            audience.clearTitle();
        }
    }

    @Override
    default public void resetTitle() {
        for (Audience audience : this.audiences()) {
            audience.resetTitle();
        }
    }

    @Override
    default public void showBossBar(@NonNull BossBar bar) {
        for (Audience audience : this.audiences()) {
            audience.showBossBar(bar);
        }
    }

    @Override
    default public void hideBossBar(@NonNull BossBar bar) {
        for (Audience audience : this.audiences()) {
            audience.hideBossBar(bar);
        }
    }

    @Override
    default public void playSound(@NonNull Sound sound) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound);
        }
    }

    @Override
    default public void playSound(@NonNull Sound sound, double x, double y, double z) {
        for (Audience audience : this.audiences()) {
            audience.playSound(sound, x, y, z);
        }
    }

    @Override
    default public void stopSound(@NonNull SoundStop stop) {
        for (Audience audience : this.audiences()) {
            audience.stopSound(stop);
        }
    }

    @Override
    default public void openBook(@NonNull Book book) {
        for (Audience audience : this.audiences()) {
            audience.openBook(book);
        }
    }

    public static interface Single
    extends ForwardingAudience {
        public @NonNull Audience audience();

        @Override
        @Deprecated
        default public @NonNull Iterable<? extends Audience> audiences() {
            return Collections.singleton(this.audience());
        }

        @Override
        default public void sendMessage(@NonNull Component message, @NonNull MessageType type) {
            this.audience().sendMessage(message, type);
        }

        @Override
        default public void sendActionBar(@NonNull Component message) {
            this.audience().sendActionBar(message);
        }

        @Override
        default public void showTitle(@NonNull Title title) {
            this.audience().showTitle(title);
        }

        @Override
        default public void clearTitle() {
            this.audience().clearTitle();
        }

        @Override
        default public void resetTitle() {
            this.audience().resetTitle();
        }

        @Override
        default public void showBossBar(@NonNull BossBar bar) {
            this.audience().showBossBar(bar);
        }

        @Override
        default public void hideBossBar(@NonNull BossBar bar) {
            this.audience().hideBossBar(bar);
        }

        @Override
        default public void playSound(@NonNull Sound sound) {
            this.audience().playSound(sound);
        }

        @Override
        default public void playSound(@NonNull Sound sound, double x, double y, double z) {
            this.audience().playSound(sound, x, y, z);
        }

        @Override
        default public void stopSound(@NonNull SoundStop stop) {
            this.audience().stopSound(stop);
        }

        @Override
        default public void openBook(@NonNull Book book) {
            this.audience().openBook(book);
        }
    }
}

