/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.configs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class GSConfigSchematics {
    public static boolean loaded;
    public static Configuration config;
    public static int idSchematicCone;
    public static int idSchematicBody;
    public static int idSchematicEngine;
    public static int idSchematicBooster;
    public static int idSchematicFins;
    public static int idSchematicOxTank;
    public static boolean enableDuplicateSchematic;

    public GSConfigSchematics(File file) {
        if (!loaded) {
            config = new Configuration(file);
            GSConfigSchematics.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!GSConfigSchematics.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("general", "enableDuplicateSchematic", true);
            prop.setComment("Enable/Disable make duplicate schematic.");
            prop.setLanguageKey("gc.configgui.enableDuplicateSchematic").setRequiresMcRestart(true);
            enableDuplicateSchematic = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicCone", 11);
            prop.setComment("Schematic ID for Cone (Rocket Detail), must be unique.");
            prop.setLanguageKey("gc.configgui.idSchematicCone").setRequiresMcRestart(false);
            idSchematicCone = prop.getInt(11);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicBody", 12);
            prop.setComment("Schematic ID for Body (Rocket Detail), must be unique.");
            prop.setLanguageKey("gc.configgui.idSchematicBody").setRequiresMcRestart(false);
            idSchematicBody = prop.getInt(12);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicEngine", 13);
            prop.setComment("Schematic ID for Engine (Rocket Detail), must be unique.");
            prop.setLanguageKey("gc.configgui.idSchematicEngine").setRequiresMcRestart(false);
            idSchematicEngine = prop.getInt(13);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicBooster", 14);
            prop.setComment("Schematic ID for Booster (Rocket Detail), must be unique.");
            prop.setLanguageKey("gc.configgui.idSchematicBooster").setRequiresMcRestart(false);
            idSchematicBooster = prop.getInt(14);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicFins", 15);
            prop.setComment("Schematic ID for Fins (Rocket Detail), must be unique.");
            prop.setLanguageKey("gc.configgui.idSchematicFins").setRequiresMcRestart(false);
            idSchematicFins = prop.getInt(15);
            propOrder.add(prop.getName());
            prop = config.get("schematic", "idSchematicOxTank", 16);
            prop.setComment("Schematic ID for Oxygen PPE Tank, must be unique.");
            prop.setLanguageKey("gc.configgui.idSchematicOxTank").setRequiresMcRestart(false);
            idSchematicOxTank = prop.getInt(16);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"GalaxySpace (Schematics) has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("difficulty")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("client")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("controls")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("compatibility")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("server")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("schematic")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("entities")).getChildElements());
        return list;
    }

    static {
        idSchematicCone = 11;
        idSchematicBody = 12;
        idSchematicEngine = 13;
        idSchematicBooster = 14;
        idSchematicFins = 15;
        idSchematicOxTank = 16;
    }
}

