/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.gui;

import galaxyspace.GalaxySpace;
import galaxyspace.core.GSItems;
import galaxyspace.core.client.gui.tile.GuiTileBase;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.systems.SolarSystem.planets.overworld.inventory.ContainerGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiGravitationModule
extends GuiTileBase
implements GuiElementTextBox.ITextBoxCallback,
GuiElementCheckbox.ICheckBoxCallback {
    private GuiElementCheckbox checkboxRenderEffects;
    private TileEntityGravitationModule tileEntity;
    protected List<GuiElementTextBox> inputFieldList = new ArrayList<GuiElementTextBox>();
    private GuiButton disableButton;
    private GuiElementTextBox strengthField;
    public final int BTN_ENABLE = 6;
    public final int FIELD_STRENGTH = 10;
    private int radius;

    public GuiGravitationModule(InventoryPlayer par1InventoryPlayer, TileEntityGravitationModule tileEntity) {
        super(new ContainerGravitationModule(par1InventoryPlayer, tileEntity), 2, 1);
        this.tileEntity = tileEntity;
        this.field_147000_g = 204;
        this.moduleInfoX = this.field_147002_h.func_75147_a((IInventory)tileEntity, (int)1).field_75223_e;
        this.moduleInfoY = this.field_147002_h.func_75147_a((IInventory)tileEntity, (int)1).field_75221_f;
        this.radius = tileEntity.getGravityRadius();
        this.moduleList = new ItemStack[]{new ItemStack(GSItems.UPGRADES, 1, 0), new ItemStack(GSItems.UPGRADES, 1, 3)};
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.disableButton = new GuiButton(6, var5 + 110, var6 + 63, 50, 20, GCCoreUtil.translate((String)"gui.button.disable.name"));
        this.checkboxRenderEffects = new GuiElementCheckbox(0, (GuiElementCheckbox.ICheckBoxCallback)this, var5 + 10, var6 + 65, EnumColor.WHITE + GCCoreUtil.translate((String)"gui.message.effect_visible.name"));
        this.field_146292_n.add(this.checkboxRenderEffects);
        this.field_146292_n.add(this.disableButton);
        this.strengthField = new GuiElementTextBox(10, (GuiElementTextBox.ITextBoxCallback)this, var5 + 110, var6 + 41, 38, 18, "0", true, 2, true);
        this.addInputField(this.strengthField);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        TextFormatting color = this.getStyle() == GuiTileBase.Style.MODERN ? TextFormatting.WHITE : TextFormatting.DARK_GRAY;
        this.checkboxRenderEffects.field_146126_j = color + GCCoreUtil.translate((String)"gui.message.effect_visible.name");
        this.field_146289_q.func_78276_b(color + GCCoreUtil.translate((String)"gui.gravity.radius.name"), 11, 46, 0x404040);
        String displayText = "";
        if (this.tileEntity.getDisabled(0)) {
            displayText = EnumColor.RED + GCCoreUtil.translate((String)"gui.status.disabled.name");
            this.disableButton.field_146126_j = GCCoreUtil.translate((String)"gui.button.enable.name");
        } else {
            displayText = this.tileEntity.hasEnoughEnergyToRun ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.running.name") : EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.idle.name");
            this.disableButton.field_146126_j = GCCoreUtil.translate((String)"gui.button.disable.name");
        }
        this.field_146289_q.func_78276_b(color + GCCoreUtil.translate((String)"gui.message.status.name") + ": " + displayText, 100, 104, 0x404040);
        for (int i = 0; i < 4; ++i) {
            if (!this.tileEntity.func_70301_a(i + 1).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 1))) continue;
            this.field_146289_q.func_78279_b(EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.message.active_pressure_shield.name"), 10, 20, 160, 0x404040);
            break;
        }
        this.strengthField.text = this.tileEntity.getGravityRadius() + "";
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.renderEnergyBar(containerWidth + 4, containerHeight + 102, this.tileEntity.getScaledElecticalLevel(55), this.tileEntity.getEnergyStoredGC(), this.tileEntity.getMaxEnergyStoredGC());
        this.checkboxRenderEffects.isSelected = this.tileEntity.shouldRenderEffects;
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        this.tileEntity.shouldRenderEffects = newSelected;
        GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), 6, this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), newSelected ? 1 : 0));
    }

    protected void sendDataToServer() {
        BlockVec3 pos = new BlockVec3((TileEntity)this.tileEntity);
        int actualStrength = this.radius;
        if (actualStrength > 16) {
            actualStrength = 16;
        }
        GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_GRAVITY_RADIUS, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), pos, actualStrength));
        this.tileEntity.setGravityRadius(actualStrength);
    }

    protected void func_146284_a(GuiButton btn) {
        switch (btn.field_146127_k) {
            case 6: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.tileEntity.func_174877_v(), 0}));
            }
        }
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (keyID != 1) {
            for (GuiElementTextBox box : this.inputFieldList) {
                if (!box.keyTyped(keyChar, keyID)) continue;
                return;
            }
        }
        super.func_73869_a(keyChar, keyID);
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return this.tileEntity.shouldRenderEffects;
    }

    public void onIntruderInteraction() {
    }

    protected void addInputField(GuiElementTextBox box) {
        this.field_146292_n.add(box);
        this.inputFieldList.add(box);
    }

    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return false;
    }

    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        double newValue;
        if (newText == null) {
            return;
        }
        try {
            newValue = Double.parseDouble(newText);
        }
        catch (NumberFormatException wat) {
            return;
        }
        if (newValue < 0.0) {
            return;
        }
        switch (textBox.field_146127_k) {
            case 10: {
                this.radius = (int)newValue;
                break;
            }
            default: {
                return;
            }
        }
        this.sendDataToServer();
    }

    public String getInitialText(GuiElementTextBox textBox) {
        switch (textBox.field_146127_k) {
            case 10: {
                return Integer.toString(this.radius);
            }
        }
        return Integer.toString(textBox.field_146127_k);
    }

    public int getTextColor(GuiElementTextBox textBox) {
        return ColorUtil.to32BitColor((int)255, (int)20, (int)255, (int)20);
    }

    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }

    @Override
    protected boolean isModuleSupport() {
        return true;
    }

    @Override
    protected String getName() {
        return this.tileEntity.func_70005_c_();
    }

    @Override
    protected Slot getBatterySlot() {
        return this.field_147002_h.func_75147_a((IInventory)this.tileEntity, 0);
    }
}

